/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockingUtilities;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class RelativeDockablePosition {
    public static final RelativeDockablePosition TOP = new RelativeDockablePosition(0.0, 0.0, 1.0, 0.2);
    public static final RelativeDockablePosition TOP_CENTER = new RelativeDockablePosition(0.4, 0.0, 0.2, 0.2);
    public static final RelativeDockablePosition TOP_RIGHT = new RelativeDockablePosition(0.0, 0.0, 0.2, 0.2);
    public static final RelativeDockablePosition TOP_LEFT = new RelativeDockablePosition(0.8, 0.0, 0.2, 0.2);
    public static final RelativeDockablePosition RIGHT = new RelativeDockablePosition(0.8, 0.0, 0.2, 1.0);
    public static final RelativeDockablePosition RIGHT_CENTER = new RelativeDockablePosition(0.8, 0.4, 0.2, 0.2);
    public static final RelativeDockablePosition BOTTOM_RIGHT = new RelativeDockablePosition(0.8, 0.8, 0.2, 0.2);
    public static final RelativeDockablePosition BOTTOM = new RelativeDockablePosition(0.0, 0.8, 1.0, 0.2);
    public static final RelativeDockablePosition BOTTOM_CENTER = new RelativeDockablePosition(0.4, 0.8, 0.2, 0.2);
    public static final RelativeDockablePosition BOTTOM_LEFT = new RelativeDockablePosition(0.0, 0.8, 0.2, 0.2);
    public static final RelativeDockablePosition LEFT = new RelativeDockablePosition(0.0, 0.0, 0.2, 1.0);
    public static final RelativeDockablePosition LEFT_CENTER = new RelativeDockablePosition(0.0, 0.4, 0.2, 0.2);
    private double x;
    private double y;
    private double w;
    private Container relativeAncestorContainer;
    private double h;
    private int anchors;

    RelativeDockablePosition(Container relativeAncestorContainer, Dockable dockable) {
        this.resetRelativePosition(relativeAncestorContainer, dockable);
    }

    public RelativeDockablePosition() {
    }

    public RelativeDockablePosition(double x, double y, double w, double h) {
        this(null, x, y, w, h);
    }

    public RelativeDockablePosition(Container relativeAncestorContainer, double x, double y, double w, double h) {
        this.relativeAncestorContainer = relativeAncestorContainer;
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x is out of bounds [0.0 , 1.0] " + x);
        }
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("y is out of bounds [0.0 , 1.0] " + y);
        }
        if (w < 0.0 || w > 1.0) {
            throw new IllegalArgumentException("w is out of bounds [0.0 , 1.0] " + w);
        }
        if (h < 0.0 || h > 1.0) {
            throw new IllegalArgumentException("h is out of bounds [0.0 , 1.0] " + h);
        }
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public String toString() {
        return "RelativePosition [" + this.x + ", " + this.y + ", " + this.w + ", " + this.h + ", anchors=" + this.anchors + "]";
    }

    public Container getRelativeAncestorContainer() {
        return this.relativeAncestorContainer;
    }

    public int getAnchors() {
        return this.anchors;
    }

    public void resetRelativePosition(Container relativeAncestorContainer, Dockable dockable) {
        this.relativeAncestorContainer = relativeAncestorContainer;
        SingleDockableContainer dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
        if (dockableContainer != null && relativeAncestorContainer != null) {
            Component c = (Component)((Object)dockableContainer);
            Rectangle converted = SwingUtilities.convertRectangle(c, new Rectangle(0, 0, c.getWidth(), c.getHeight()), relativeAncestorContainer);
            this.x = (float)converted.x / (float)relativeAncestorContainer.getWidth();
            this.y = (float)converted.y / (float)relativeAncestorContainer.getHeight();
            this.w = (float)converted.width / (float)relativeAncestorContainer.getWidth();
            this.h = (float)converted.height / (float)relativeAncestorContainer.getHeight();
            this.anchors = RelativeDockingUtilities.findAnchors(dockable.getComponent(), relativeAncestorContainer);
        }
    }
}

