/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.HttpCyclotis;
import org.silvestrislab.cyclotis.omegat.tm.PropertiesStore;

public abstract class HttpCyclotisTMX<T extends PrepareTMXEntry>
extends HttpCyclotis<T> {
    public static final int COL_AUTHOR = 2;
    public static final int COL_DATE = 3;
    public static final int COL_CHANGER = 4;
    public static final int COL_CHANGEDATE = 5;
    public static final int COL_PROPS = 6;
    public static final int COL_NOTE = 7;
    private String author;
    public final PropertiesStore store;

    protected HttpCyclotisTMX(Properties propList) {
        super(propList);
        this.author = propList.getProperty("author");
        if (this.author == null) {
            this.author = Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name"));
        }
        this.store = new PropertiesStore(this, propList);
    }

    protected HttpCyclotisTMX(HttpCyclotisTMX ori) {
        super(ori);
        this.author = ori.author;
        this.store = ori.store;
    }

    @Override
    protected Map<String, String> encodeArgs(T entry) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("src", this.reformatText(((PrepareTMXEntry)entry).source, false));
        args.put("tra", this.reformatText(((PrepareTMXEntry)entry).translation, false));
        args.put("author", this.author);
        if (((PrepareTMXEntry)entry).note != null) {
            args.put("note", ((PrepareTMXEntry)entry).note);
        }
        if (((PrepareTMXEntry)entry).otherProperties != null) {
            for (TMXProp prop : ((PrepareTMXEntry)entry).otherProperties) {
                args.put("props." + prop.getType(), prop.getValue());
            }
        }
        return args;
    }

    @Override
    public StringBuffer entryToLogString(T entry, boolean detailed, boolean digest) {
        StringBuffer buf = detailed ? new StringBuffer("\t<TMX Entry author='" + ((PrepareTMXEntry)entry).creator + "' creation-date='" + LONG_LOG_DATE_FORMAT.format(new Date(((PrepareTMXEntry)entry).creationDate)) + "' changer = '" + ((PrepareTMXEntry)entry).changer + "' change-date='" + LONG_LOG_DATE_FORMAT.format(new Date(((PrepareTMXEntry)entry).changeDate)) + ">\n") : new StringBuffer("\t<TMX Entry>\n");
        if (!digest) {
            buf.append("\t\t<source>" + ((PrepareTMXEntry)entry).source + "</source>\n");
            buf.append("\t\t<target>" + ((PrepareTMXEntry)entry).translation + "</target>\n");
        } else {
            buf.append("\t\t<source digest='" + this.digest(((PrepareTMXEntry)entry).source) + "'>" + ((PrepareTMXEntry)entry).source + "</source>\n");
            buf.append("\t\t<target digest='" + this.digest(((PrepareTMXEntry)entry).translation) + "'>" + ((PrepareTMXEntry)entry).translation + "</target>\n");
        }
        buf.append("\t</TMX Entry>");
        return buf;
    }
}

