/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tagging.de.GermanToken;

public final class GermanHelper {
    private GermanHelper() {
    }

    public static boolean hasReadingOfType(AnalyzedTokenReadings tokenReadings, GermanToken.POSType type) {
        if (tokenReadings == null) {
            return false;
        }
        for (AnalyzedToken token : tokenReadings) {
            if (token.getPOSTag() != null && (token.getPOSTag().equals("SENT_END") || token.getPOSTag().equals("PARA_END"))) {
                return false;
            }
            AnalyzedGermanToken germanToken = new AnalyzedGermanToken(token);
            if (germanToken.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static String getNounCase(String posTag) {
        return GermanHelper.getIndexOrEmptyString(posTag, 1);
    }

    public static String getNounNumber(String posTag) {
        return GermanHelper.getIndexOrEmptyString(posTag, 2);
    }

    public static String getNounGender(String posTag) {
        return GermanHelper.getIndexOrEmptyString(posTag, 3);
    }

    public static String getDeterminerDefiniteness(String posTag) {
        return GermanHelper.getIndexOrEmptyString(posTag, 1);
    }

    public static String getDeterminerCase(String posTag) {
        return GermanHelper.getIndexOrEmptyString(posTag, 2);
    }

    public static String getDeterminerNumber(String posTag) {
        return GermanHelper.getIndexOrEmptyString(posTag, 3);
    }

    public static String getDeterminerGender(String posTag) {
        return GermanHelper.getIndexOrEmptyString(posTag, 4);
    }

    private static String getIndexOrEmptyString(String posTag, int idx) {
        if (posTag == null) {
            return "";
        }
        String[] array = posTag.split(":");
        if (array.length > idx) {
            return array[idx];
        }
        return "";
    }
}

