/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import com.vlsolutions.swing.docking.DockingDesktop;
import gen.core.filters.Filters;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.omegat.CLIParameters;
import org.omegat.convert.ConvertConfigs;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ExternalTMFactory;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.lucene.LuceneWriter;
import org.omegat.core.matching.external.rmi.GUIServer;
import org.omegat.core.matching.external.rmi.ProjectServer;
import org.omegat.core.matching.external.rmi.RAMServer;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.core.team2.TeamTool;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.scripting.ConsoleBindings;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.gui.scripting.ScriptRunner;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXWriter;
import org.omegat.util.gui.OSXIntegration;

public final class Main {
    protected static File projectLocation = null;
    protected static String remoteProject = null;
    protected static final Map<String, String> PARAMS = new TreeMap<String, String>();
    protected static CLIParameters.RUN_MODE runMode = CLIParameters.RUN_MODE.GUI;

    private Main() {
    }

    public static void main(String[] args) {
        int result;
        String configDir;
        if (args.length > 0 && ("-h".equals(args[0]) || "--help".equals(args[0]))) {
            System.out.println(StringUtil.format(OStrings.getString("COMMAND_LINE_HELP"), OStrings.getNameAndVersion()));
            System.exit(0);
        }
        if (args.length > 0 && "team".equals(args[0])) {
            TeamTool.main(Arrays.copyOfRange(args, 1, args.length));
        }
        System.setProperty("jna.encoding", Charset.defaultCharset().name());
        PARAMS.putAll(CLIParameters.parseArgs(args));
        String projectDir = PARAMS.get("project");
        if (projectDir != null) {
            projectLocation = new File(projectDir);
        }
        remoteProject = PARAMS.get("remote-project");
        Main.applyConfigFile(PARAMS.get("config-file"));
        runMode = CLIParameters.RUN_MODE.parse(PARAMS.get("mode"));
        String resourceBundle = PARAMS.get("resource-bundle");
        if (resourceBundle != null) {
            OStrings.loadBundle(resourceBundle);
        }
        if ((configDir = PARAMS.get("config-dir")) != null) {
            RuntimePreferences.setConfigDir(configDir);
        }
        if (PARAMS.containsKey("quiet")) {
            RuntimePreferences.setQuietMode(true);
        }
        if (PARAMS.containsKey("disable-project-locking")) {
            RuntimePreferences.setProjectLockingEnabled(false);
        }
        if (PARAMS.containsKey("disable-location-save")) {
            RuntimePreferences.setLocationSaveEnabled(false);
        }
        Log.log("\n===================================================================\n" + OStrings.getNameAndVersion() + " (" + new Date() + ")  Locale " + Locale.getDefault());
        Log.logRB("LOG_STARTUP_INFO", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home"));
        System.setProperty("http.agent", OStrings.getDisplayNameAndVersion());
        ConvertConfigs.convert();
        Preferences.init();
        PluginUtils.loadPlugins(PARAMS);
        FilterMaster.setFilterClasses(PluginUtils.getFilterClasses());
        Preferences.initFilters();
        Preferences.initSegmentation();
        if (PARAMS.containsKey("server-port")) {
            try {
                LocateRegistry.createRegistry(Integer.parseInt(PARAMS.get("server-port")));
                System.err.println("Listening server " + PARAMS.get("server-port"));
            }
            catch (Exception rmi1) {
                rmi1.printStackTrace();
            }
        }
        if (PARAMS.containsKey("server-object")) {
            try {
                String object = PARAMS.get("server-object");
                if (!object.startsWith("rmi:")) {
                    object = "rmi://" + InetAddress.getLocalHost().getHostAddress() + "/" + object;
                }
                System.err.println("Listening server object " + PARAMS.get("server.object"));
                if (runMode == CLIParameters.RUN_MODE.GUI) {
                    Naming.rebind(object, new GUIServer());
                } else if (projectLocation != null) {
                    Naming.rebind(object, new ProjectServer());
                } else {
                    Naming.rebind(object, new RAMServer());
                }
            }
            catch (Exception rmi2) {
                rmi2.printStackTrace();
            }
        }
        try {
            switch (runMode) {
                case GUI: {
                    result = Main.runGUI();
                    break;
                }
                case CONSOLE_TRANSLATE: {
                    result = Main.runConsoleTranslate();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_CREATEPSEUDOTRANSLATETMX: {
                    result = Main.runCreatePseudoTranslateTMX();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_ALIGN: {
                    result = Main.runConsoleAlign();
                    PluginUtils.unloadPlugins();
                    break;
                }
                case CONSOLE_INDEX_MEMORY: {
                    result = Main.runConsoleIndexMemory();
                    PluginUtils.unloadPlugins();
                    break;
                }
                default: {
                    result = 1;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            result = 1;
        }
        if (result != 0) {
            System.exit(result);
        }
    }

    private static void applyConfigFile(String path) {
        if (path == null) {
            return;
        }
        File configFile = new File(path);
        if (!configFile.exists()) {
            return;
        }
        System.out.println("Reading config from " + path);
        try (FileInputStream in = new FileInputStream(configFile);){
            PropertyResourceBundle config = new PropertyResourceBundle(in);
            for (String key : config.keySet()) {
                String value = config.getString(key);
                System.setProperty(key, value);
                PARAMS.put(key, value);
                System.out.println("Read from config: " + key + "=" + value);
            }
            if (config.containsKey("user.language")) {
                String userLanguage = config.getString("user.language");
                Locale userLocale = config.containsKey("user.country") ? new Locale(userLanguage, config.getString("user.country")) : new Locale(userLanguage);
                Locale.setDefault(userLocale);
            }
        }
        catch (FileNotFoundException exception) {
            System.err.println("Config file not found: " + path);
        }
        catch (IOException exception) {
            System.err.println("Error while reading config file: " + path);
        }
    }

    protected static int runGUI() {
        if (Platform.isMacOSX()) {
            OSXIntegration.init();
        }
        Log.log("Docking Framework version: " + DockingDesktop.getDockingFrameworkVersion());
        Log.log("");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> cls = toolkit.getClass();
        try {
            if (cls.getName().equals("sun.awt.X11.XToolkit")) {
                Field field = cls.getDeclaredField("awtAppClassName");
                field.setAccessible(true);
                field.set(toolkit, "OmegaT");
            }
        }
        catch (Exception field) {
            // empty catch block
        }
        try {
            UIManager.getInstalledLookAndFeels();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("swing.aatext", "true");
        }
        catch (Exception e) {
            Log.logErrorRB("MAIN_ERROR_CANT_INIT_OSLF", new Object[0]);
        }
        try {
            Core.initializeGUI(PARAMS);
        }
        catch (Throwable ex) {
            Log.log(ex);
            Main.showError(ex);
            return 1;
        }
        if (!Core.getPluginsLoadingErrors().isEmpty()) {
            String err = String.join((CharSequence)"\n", Core.getPluginsLoadingErrors());
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), err, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
        }
        CoreEvents.fireApplicationStartup();
        SwingUtilities.invokeLater(() -> {
            Core.getMainWindow().getApplicationFrame().setVisible(true);
            if (remoteProject != null) {
                ProjectUICommands.projectRemote(remoteProject);
            } else if (projectLocation != null) {
                ProjectUICommands.projectOpen(projectLocation);
            }
        });
        return 0;
    }

    protected static int runConsoleTranslate() throws Exception {
        Log.log("Console translation mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(PARAMS);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_TRANSLATING"));
        String sourceMask = PARAMS.get("source-pattern");
        if (sourceMask != null) {
            p.compileProject(sourceMask, false);
        } else {
            p.compileProject(".*", false);
        }
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        p.closeProject();
        Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE);
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    private static void validateTagsConsoleMode() {
        CLIParameters.TAG_VALIDATION_MODE mode = CLIParameters.TAG_VALIDATION_MODE.parse(PARAMS.get("tag-validation"));
        switch (mode) {
            case ABORT: {
                System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
                List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
                if (stes.isEmpty()) break;
                Core.getTagValidation().logTagValidationErrors(stes);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_ABORT"));
                System.exit(1);
                break;
            }
            case WARN: {
                System.out.println(OStrings.getString("CONSOLE_VALIDATING_TAGS"));
                List<ErrorReport> stes = Core.getTagValidation().listInvalidTags();
                if (stes.isEmpty()) break;
                Core.getTagValidation().logTagValidationErrors(stes);
                System.out.println(OStrings.getString("CONSOLE_TAGVALIDATION_FAIL"));
                break;
            }
        }
    }

    protected static int runCreatePseudoTranslateTMX() throws Exception {
        Log.log("Console pseudo-translate mode");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(PARAMS);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(OStrings.getString("CONSOLE_CREATE_PSEUDOTMX"));
        ProjectProperties config = p.getProjectProperties();
        List<SourceTextEntry> entries = p.getAllEntries();
        String pseudoTranslateTMXFilename = PARAMS.get("pseudotranslatetmx");
        CLIParameters.PSEUDO_TRANSLATE_TYPE pseudoTranslateType = CLIParameters.PSEUDO_TRANSLATE_TYPE.parse(PARAMS.get("pseudotranslatetype"));
        String fname = !StringUtil.isEmpty(pseudoTranslateTMXFilename) ? (!pseudoTranslateTMXFilename.endsWith(".tmx") ? pseudoTranslateTMXFilename + "." + ".tmx" : pseudoTranslateTMXFilename) : "";
        HashMap<String, PrepareTMXEntry> data = new HashMap<String, PrepareTMXEntry>();
        for (SourceTextEntry ste : entries) {
            PrepareTMXEntry entry = new PrepareTMXEntry();
            entry.source = ste.getSrcText();
            switch (pseudoTranslateType) {
                case EQUAL: {
                    entry.translation = ste.getSrcText();
                    break;
                }
                case EMPTY: {
                    entry.translation = "";
                }
            }
            data.put(ste.getSrcText(), entry);
        }
        try {
            TMXWriter.buildTMXFile(fname, false, false, config, data);
        }
        catch (IOException e) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(e);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
        }
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    public static int runConsoleAlign() throws Exception {
        Log.log("Console alignment mode");
        Log.log("");
        if (projectLocation == null) {
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            return 1;
        }
        String dir = PARAMS.get("alignDir");
        if (dir == null) {
            System.out.println(OStrings.getString("CONSOLE_TRANSLATED_FILES_LOC_UNDEFINED"));
            return 1;
        }
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(PARAMS);
        RealProject p = Main.selectProjectConsoleMode(true);
        Main.validateTagsConsoleMode();
        System.out.println(StringUtil.format(OStrings.getString("CONSOLE_ALIGN_AGAINST"), dir));
        Map<String, TMXEntry> data = p.align(p.getProjectProperties(), new File(dir));
        TreeMap<String, PrepareTMXEntry> result = new TreeMap<String, PrepareTMXEntry>();
        for (Map.Entry<String, TMXEntry> en : data.entrySet()) {
            result.put(en.getKey(), new PrepareTMXEntry(en.getValue()));
        }
        String tmxFile = p.getProjectProperties().getProjectInternal() + "align.tmx";
        TMXWriter.buildTMXFile(tmxFile, false, false, p.getProjectProperties(), result);
        p.closeProject();
        System.out.println(OStrings.getString("CONSOLE_FINISHED"));
        return 0;
    }

    protected static int runConsoleIndexMemory() throws Exception {
        boolean isSentenceSegmentingEnabled;
        Language targetLanguage;
        Language sourceLanguage;
        ArrayList<File> saveDirs;
        ArrayList<File> targetDirs;
        List<File> sourceFiles;
        Log.log("Console index memory");
        Log.log("");
        System.out.println(OStrings.getString("CONSOLE_INITIALIZING"));
        Core.initializeConsole(PARAMS);
        String tmxPath = PARAMS.get("source");
        if (tmxPath != null) {
            String targetPath = PARAMS.get("target");
            String sourceLang = PARAMS.get("source-lang");
            String targetLang = PARAMS.get("target-lang");
            File tmxFile = new File(tmxPath);
            File targetDir = new File(targetPath);
            if (!tmxFile.exists()) {
                Log.log("File " + tmxPath + " not found. Exit");
                return 1;
            }
            if (targetDir.exists()) {
                if (!targetDir.isDirectory()) {
                    Log.log("Target path " + targetPath + " is not a directory. Exit.");
                    return 1;
                }
            } else {
                if (sourceLang == null) {
                    Log.log("Missing parameter source-lang");
                    return 1;
                }
                if (targetLang == null) {
                    Log.log("Missing parameter target-lang");
                    return 1;
                }
            }
            sourceFiles = new ArrayList<File>(1);
            sourceFiles.add(tmxFile);
            targetDirs = new ArrayList(1);
            targetDirs.add(targetDir);
            saveDirs = null;
            sourceLanguage = new Language(sourceLang);
            targetLanguage = new Language(targetLang);
            isSentenceSegmentingEnabled = PARAMS.get("source-segmenting-enabled") != null;
            Core.setSegmenter(new Segmenter(Preferences.getSRX()));
            Core.setFilterMaster(new FilterMaster(Preferences.getFilters()));
        } else {
            String idxRoot;
            if (projectLocation == null) {
                System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
                return 1;
            }
            RealProject p = Main.selectProjectConsoleMode(false);
            Filters filters = p.getProjectProperties().getProjectFilters();
            if (filters == null) {
                filters = Preferences.getFilters();
            }
            Core.setFilterMaster(new FilterMaster(filters));
            sourceFiles = FileUtil.findFiles(new File(p.getProjectProperties().getTMRoot()), f -> ExternalTMFactory.isSupported(f) && !f.getName().endsWith(".properties"));
            targetDirs = new ArrayList<File>(sourceFiles.size());
            saveDirs = new ArrayList<File>(sourceFiles.size());
            String projRoot = p.getProjectProperties().getProjectRoot();
            String tmRoot = p.getProjectProperties().getTMRoot();
            if (!tmRoot.endsWith(File.separator)) {
                tmRoot = tmRoot + File.separator;
            }
            if (!(idxRoot = projRoot).endsWith(File.separator)) {
                idxRoot = idxRoot + File.separator;
            }
            idxRoot = idxRoot + "tm-indexes";
            new File(idxRoot).mkdirs();
            for (File sourceFile : sourceFiles) {
                targetDirs.add(new File(idxRoot + File.separator + sourceFile.getPath().substring(tmRoot.length()) + ".ottm"));
                if (PARAMS.get("save-to") != null) {
                    saveDirs.add(new File(PARAMS.get("save-to") + sourceFile.getPath().substring(tmRoot.length())));
                    continue;
                }
                if (!PARAMS.containsKey("save-files")) continue;
                saveDirs.add(new File(projRoot + File.separator + "tm-saved" + File.separator + sourceFile.getPath().substring(tmRoot.length())));
            }
            sourceLanguage = p.getProjectProperties().getSourceLanguage();
            targetLanguage = p.getProjectProperties().getTargetLanguage();
            isSentenceSegmentingEnabled = p.getProjectProperties().isSentenceSegmentingEnabled();
            SRX srx = p.getProjectProperties().getProjectSRX();
            Core.setSegmenter(new Segmenter(srx == null ? Preferences.getSRX() : srx));
        }
        for (int i = 0; i < targetDirs.size(); ++i) {
            try {
                try (FileOutputStream propFile = new FileOutputStream(sourceFiles.get(i) + ".properties");
                     PrintWriter pOut = new PrintWriter(propFile);){
                    pOut.println("class=org.omegat.core.matching.external.lucene.LuceneReader");
                    pOut.println("dir=" + ((File)targetDirs.get(i)).toString().replace("\\", "\\\\"));
                }
                ((File)targetDirs.get(i)).mkdir();
                LuceneWriter writer = new LuceneWriter((File)targetDirs.get(i), true);
                IBrowsableMemory tmx = (IBrowsableMemory)ExternalTMFactory.load(sourceFiles.get(i));
                writer.indexAll(tmx.getEntries());
                writer.close();
                if (tmxPath != null) continue;
                if (saveDirs.size() > i && saveDirs.get(i) != null) {
                    ((File)saveDirs.get(i)).getParentFile().mkdirs();
                    sourceFiles.get(i).renameTo((File)saveDirs.get(i));
                    continue;
                }
                sourceFiles.get(i).delete();
                continue;
            }
            catch (Exception e) {
                Log.log(e);
                return 1;
            }
        }
        return 0;
    }

    private static RealProject selectProjectConsoleMode(boolean loadProject) {
        System.out.println(OStrings.getString("CONSOLE_LOADING_PROJECT"));
        ProjectProperties projectProperties = null;
        try {
            projectProperties = ProjectFileStorage.loadProjectProperties(projectLocation);
            projectProperties.verifyProject();
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
            System.out.println(OStrings.getString("PP_ERROR_UNABLE_TO_READ_PROJECT_FILE"));
            System.exit(1);
        }
        RealProject p = new RealProject(projectProperties);
        Core.setProject(p);
        if (loadProject) {
            p.loadProject(true);
            if (!p.isProjectLoaded()) {
                Core.setProject(new NotLoadedProject());
            } else {
                Main.executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
            }
        }
        return p;
    }

    private static void executeConsoleScript(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        if (PARAMS.containsKey("script")) {
            File script = new File(PARAMS.get("script").toString());
            Log.log(OStrings.getString("CONSOLE_EXECUTE_SCRIPT", new Object[]{script, eventType}));
            if (script.isFile()) {
                HashMap<String, Object> binding = new HashMap<String, Object>();
                binding.put("eventType", (Object)eventType);
                ConsoleBindings consoleBindigs = new ConsoleBindings();
                binding.put("console", consoleBindigs);
                binding.put("glossary", consoleBindigs);
                binding.put("editor", consoleBindigs);
                try {
                    String result = ScriptRunner.executeScript(new ScriptItem(script), binding);
                    Log.log(result);
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            }
        }
    }

    public static void showError(Throwable ex) {
        String msg = StringUtil.isEmpty(ex.getMessage()) ? ex.getClass().getName() : ex.getMessage();
        switch (runMode) {
            case GUI: {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), msg, OStrings.getString("STARTUP_ERRORBOX_TITLE"), 0);
                break;
            }
            default: {
                System.err.println(MessageFormat.format(OStrings.getString("CONSOLE_ERROR"), msg));
            }
        }
    }
}

