/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.Naming;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;
import org.omegat.util.Log;
import org.omegat.util.TMXProp;

public class Client
implements ProjectMemory.IExternalProjectMemory {
    private IDistantExternalMemory remote;
    private long timeStampDiff;
    private boolean sendEntryKey;

    public Client(Properties propList) throws Exception {
        String url = propList.getProperty("url");
        this.remote = (IDistantExternalMemory)Naming.lookup(url);
        this.timeStampDiff = this.remote.timeStamp() - System.currentTimeMillis();
        if (propList.getProperty("send.entryKey") != null) {
            this.sendEntryKey = !"false".equalsIgnoreCase(propList.getProperty("send.entryKey"));
        } else {
            try {
                this.sendEntryKey = this.getProjectSignature() != this.remote.getProjectSignature();
                Log.log("Client and server " + (this.sendEntryKey ? " use same project" : " use distinct project"));
            }
            catch (Exception e) {
                this.sendEntryKey = true;
            }
        }
    }

    public int getProjectSignature() {
        List<SourceTextEntry> entries = Core.getProject().getAllEntries();
        int signature = entries.size();
        for (SourceTextEntry ste : entries) {
            signature += ste.getKey().hashCode();
        }
        return signature;
    }

    public List<ProjectMemory.ContextTMXEntry> findChanges(long timeStamp) throws Exception {
        return this.remote.findChanges(this.sendEntryKey, timeStamp + this.timeStampDiff);
    }

    @Override
    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        if (this.sendEntryKey && !entry.isDefault) {
            if (entry.otherProperties == null) {
                entry.otherProperties = new ArrayList();
            }
            EntryKey eKey = Core.getProject().getAllEntries().get(entry.entryNum - 1).getKey();
            entry.otherProperties.add(new TMXProp("file", eKey.file));
            entry.otherProperties.add(new TMXProp("id", eKey.id));
            entry.otherProperties.add(new TMXProp("prev", eKey.prev));
            entry.otherProperties.add(new TMXProp("next", eKey.next));
            entry.otherProperties.add(new TMXProp("path", eKey.path));
        }
        this.remote.registerTranslation(entry);
    }

    @Override
    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws Exception {
        if (this.sendEntryKey && !entry.isDefault) {
            if (entry.otherProperties == null) {
                entry.otherProperties = new ArrayList();
            }
            EntryKey eKey = Core.getProject().getAllEntries().get(entry.entryNum - 1).getKey();
            entry.otherProperties.add(new TMXProp("file", eKey.file));
            entry.otherProperties.add(new TMXProp("id", eKey.id));
            entry.otherProperties.add(new TMXProp("prev", eKey.prev));
            entry.otherProperties.add(new TMXProp("next", eKey.next));
            entry.otherProperties.add(new TMXProp("path", eKey.path));
        }
        this.remote.removeTranslation(entry);
    }
}

