/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.omegat.externalfinder.ExternalFinder;
import org.omegat.externalfinder.gui.ExternalFinderItemEditorController;
import org.omegat.externalfinder.gui.ExternalFinderPreferencesPanel;
import org.omegat.externalfinder.item.ExternalFinderConfiguration;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;

public class ExternalFinderPreferencesController
extends BasePreferencesController {
    private static final int MAX_ROW_COUNT = 10;
    private final boolean isProjectSpecific;
    private final ExternalFinderConfiguration originalConfig;
    private ExternalFinderPreferencesPanel panel;

    public ExternalFinderPreferencesController() {
        this(false, ExternalFinder.getGlobalConfig());
    }

    public ExternalFinderPreferencesController(boolean isProjectSpecific, ExternalFinderConfiguration originalConfig) {
        this.isProjectSpecific = isProjectSpecific;
        this.originalConfig = originalConfig;
    }

    @Override
    public Component getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    private void initGui() {
        this.panel = new ExternalFinderPreferencesPanel();
        JComponent editor = this.panel.prioritySpinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)editor).getTextField().setColumns(4);
        }
        this.panel.addButton.addActionListener(e -> this.addItem());
        this.panel.removeButton.addActionListener(e -> this.removeSelection());
        this.panel.editButton.addActionListener(e -> this.editSelection());
        this.panel.prioritySpinner.addChangeListener(e -> {
            boolean changed = ((Integer)this.panel.prioritySpinner.getValue()).intValue() != this.originalConfig.getPriority();
            this.setRestartRequired(changed);
        });
        this.panel.itemTable.getSelectionModel().addListSelectionListener(e -> this.onSelectionChanged());
        Dimension tableSize = this.panel.itemTable.getPreferredSize();
        this.panel.itemTable.setPreferredScrollableViewportSize(new Dimension(tableSize.width, this.panel.itemTable.getRowHeight() * 10));
        this.panel.itemTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ExternalFinderPreferencesController.this.editSelection();
                }
            }
        });
        TableColumnSizer.autoSize(this.panel.itemTable, ItemColumn.CONTENTS.index, true);
        this.panel.globalOptionsPanel.setVisible(!this.isProjectSpecific);
    }

    private void addItem() {
        ExternalFinderItem.SCOPE scope = this.isProjectSpecific ? ExternalFinderItem.SCOPE.PROJECT : ExternalFinderItem.SCOPE.GLOBAL;
        ExternalFinderItemEditorController editor = new ExternalFinderItemEditorController(scope);
        if (editor.show(SwingUtilities.windowForComponent(this.panel))) {
            int row = this.panel.itemTable.getSelectedRow();
            ItemsTableModel model = (ItemsTableModel)this.panel.itemTable.getModel();
            int newRow = row >= 0 ? row + 1 : this.panel.itemTable.getRowCount();
            model.addItemAtRow(newRow, editor.getResult());
            this.panel.itemTable.setRowSelectionInterval(newRow, newRow);
        }
    }

    private void removeSelection() {
        int row = this.panel.itemTable.getSelectedRow();
        if (row >= 0) {
            ItemsTableModel model = (ItemsTableModel)this.panel.itemTable.getModel();
            model.removeItemAtRow(row);
        }
    }

    private void editSelection() {
        ItemsTableModel model;
        ExternalFinderItem item;
        ExternalFinderItemEditorController editor;
        int row = this.panel.itemTable.getSelectedRow();
        if (row >= 0 && (editor = new ExternalFinderItemEditorController(item = (model = (ItemsTableModel)this.panel.itemTable.getModel()).getItemAtRow(row))).show(SwingUtilities.windowForComponent(this.panel))) {
            model.setItemAtRow(row, editor.getResult());
        }
    }

    private void onSelectionChanged() {
        int row = this.panel.itemTable.getSelectedRow();
        boolean enabled = row >= 0;
        this.panel.removeButton.setEnabled(enabled);
        this.panel.editButton.setEnabled(enabled);
    }

    @Override
    public void persist() {
        if (!this.isProjectSpecific) {
            ExternalFinder.setGlobalConfig(this.getResult());
            Preferences.setPreference("external_finder_allow_project_commands", this.panel.projectSpecificCommandsCheckBox.isSelected());
        }
    }

    public ExternalFinderConfiguration getResult() {
        int priority = (Integer)this.panel.prioritySpinner.getValue();
        List<ExternalFinderItem> items = ((ItemsTableModel)this.panel.itemTable.getModel()).getItems();
        return new ExternalFinderConfiguration(priority, items);
    }

    @Override
    public void restoreDefaults() {
    }

    @Override
    protected void initFromPrefs() {
        this.panel.projectSpecificCommandsCheckBox.setSelected(Preferences.isPreference("external_finder_allow_project_commands"));
        this.panel.prioritySpinner.setValue(this.originalConfig.getPriority());
        ItemsTableModel model = new ItemsTableModel(this.originalConfig.getItems());
        this.panel.itemTable.setModel(model);
        this.onSelectionChanged();
    }

    @Override
    public String toString() {
        return this.isProjectSpecific ? OStrings.getString("PREFS_TITLE_EXTERNALFINDER_PROJ_SPECIFIC") : OStrings.getString("PREFS_TITLE_EXTERNALFINDER");
    }

    static class ItemsTableModel
    extends AbstractTableModel {
        private final List<ExternalFinderItem> data;

        ItemsTableModel(List<ExternalFinderItem> data) {
            this.data = new ArrayList<ExternalFinderItem>(data);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return ItemColumn.values().length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (ItemColumn.get(columnIndex)) {
                case NAME: {
                    return this.getItemAtRow(rowIndex).getName();
                }
                case CONTENTS: {
                    return this.getItemAtRow(rowIndex).getContentSummary();
                }
                case KEYSTROKE: {
                    KeyStroke ks = this.getItemAtRow(rowIndex).getKeystroke();
                    return ks == null ? null : StaticUIUtils.getKeyStrokeText(ks);
                }
                case NOPOPUP: {
                    return !this.getItemAtRow(rowIndex).isNopopup();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getColumnName(int column) {
            return ItemColumn.get((int)column).label;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ItemColumn.get((int)columnIndex).clazz;
        }

        ExternalFinderItem getItemAtRow(int row) {
            return this.data.get(row);
        }

        void removeItemAtRow(int row) {
            this.data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        void addItemAtRow(int row, ExternalFinderItem newItem) {
            this.data.add(row, newItem);
            this.fireTableRowsInserted(row, row);
        }

        public void setItemAtRow(int row, ExternalFinderItem newItem) {
            this.data.set(row, newItem);
            this.fireTableRowsUpdated(row, row);
        }

        public List<ExternalFinderItem> getItems() {
            return this.data;
        }
    }

    static enum ItemColumn {
        NAME(0, OStrings.getString("PREFS_EXTERNALFINDER_COL_NAME"), String.class),
        CONTENTS(1, OStrings.getString("PREFS_EXTERNALFINDER_COL_SUMMARY"), String.class),
        KEYSTROKE(2, OStrings.getString("PREFS_EXTERNALFINDER_COL_KEYSTROKE"), String.class),
        NOPOPUP(3, OStrings.getString("PREFS_EXTERNALFINDER_COL_POPUP"), Boolean.class);

        final int index;
        final String label;
        final Class<?> clazz;

        private ItemColumn(int index, String label, Class<?> clazz) {
            this.index = index;
            this.label = label;
            this.clazz = clazz;
        }

        static ItemColumn get(int index) {
            return ItemColumn.values()[index];
        }
    }
}

