/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.omegat.util.xml.XMLAttribute;

public class XMLBlock {
    private String mText;
    private String mShortcut;
    private boolean mIsClose;
    private boolean mIsComment;
    private boolean mIsStandalone;
    private boolean mIsTag;
    private boolean mHasText;
    private char mTypeChar;
    private List<XMLAttribute> mAttrList;
    private int shortcutNumber;

    public XMLBlock() {
        this.reset();
    }

    private void reset() {
        this.mText = "";
        this.mIsClose = false;
        this.mIsStandalone = false;
        this.mIsComment = false;
        this.mIsTag = false;
        this.mTypeChar = '\u0000';
        this.mHasText = false;
        this.mShortcut = "";
        if (this.mAttrList != null) {
            this.mAttrList.clear();
        }
    }

    public void setAttribute(String attribute, String value) {
        XMLAttribute attr = new XMLAttribute(attribute, value);
        this.setAttribute(attr);
    }

    private void setAttribute(XMLAttribute attr) {
        if (this.mAttrList == null) {
            this.mAttrList = new ArrayList<XMLAttribute>(8);
        }
        this.mAttrList.add(attr);
    }

    public void setText(String text) {
        this.setTag(false);
        this.mText = text;
        this.mHasText = false;
        if (text.codePointCount(0, text.length()) == 1) {
            int cp = text.codePointAt(0);
            if (cp != 9 && cp != 10 && cp != 13 && cp != 32) {
                this.mHasText = true;
            }
        } else {
            this.mHasText = true;
        }
    }

    public void setTypeChar(char c) {
        this.mTypeChar = c;
    }

    public void setShortcut(String shortcut) {
        this.mShortcut = shortcut;
    }

    public String getShortcut() {
        if (this.mShortcut != null && !this.mShortcut.equals("")) {
            if (this.mIsClose) {
                return "/" + this.mShortcut;
            }
            if (this.mIsComment) {
                return "!comment";
            }
        }
        return this.mShortcut;
    }

    public void setCloseFlag() {
        this.mIsClose = true;
        this.mIsStandalone = false;
    }

    public void setStandaloneFlag() {
        this.mIsStandalone = true;
        this.mIsClose = false;
    }

    public void setComment() {
        this.mIsTag = true;
        this.setTypeChar('!');
        this.mIsComment = true;
        this.mIsClose = false;
        this.mIsStandalone = false;
    }

    public void setTagName(String name) {
        this.setTag(true);
        this.mText = name;
    }

    private void setTag(boolean isTag) {
        this.mIsTag = isTag;
    }

    public boolean hasText() {
        return this.mHasText;
    }

    public boolean isTag() {
        return this.mIsTag;
    }

    public boolean isStandalone() {
        return this.mIsStandalone;
    }

    public boolean isClose() {
        return this.mIsClose;
    }

    public boolean isComment() {
        return this.mIsComment;
    }

    public String getText() {
        if (this.mTypeChar == '?') {
            StringBuilder tag = new StringBuilder("<?").append(this.mText);
            if (this.mAttrList != null) {
                for (XMLAttribute attr : this.mAttrList) {
                    tag.append(' ').append(attr.name).append("=\"").append(attr.value).append('\"');
                }
            }
            tag.append("?>");
            return tag.toString();
        }
        if (this.mTypeChar == '!') {
            StringBuilder tag = new StringBuilder("<!");
            if (this.mText.equals("CDATA")) {
                tag.append('[').append(this.mText).append('[');
            } else if (this.mText.equals("]]")) {
                tag.append("]]>");
            } else if (this.mIsComment) {
                tag.append("-- ").append(this.mText).append(" -->");
            } else {
                tag.append(this.mText).append(' ');
                if (this.mAttrList != null && !this.mAttrList.isEmpty()) {
                    tag.append(this.mAttrList.get((int)0).name);
                }
                tag.append('>');
            }
            return tag.toString();
        }
        if (this.isTag()) {
            StringBuilder tag = new StringBuilder("<");
            if (this.mIsClose) {
                tag.append('/');
            }
            tag.append(this.mText);
            if (this.mAttrList != null) {
                for (XMLAttribute attr : this.mAttrList) {
                    tag.append(' ').append(attr.name).append("=\"").append(attr.value).append('\"');
                }
            }
            if (this.mIsStandalone) {
                tag.append(" /");
            }
            tag.append('>');
            return tag.toString();
        }
        return this.mText;
    }

    public String getTagName() {
        if (this.isTag()) {
            return this.mText;
        }
        return "";
    }

    public int numAttributes() {
        if (this.mAttrList == null) {
            return 0;
        }
        return this.mAttrList.size();
    }

    public XMLAttribute getAttribute(int n) {
        if (n < 0 || !this.isTag() || this.mAttrList == null || n > this.mAttrList.size()) {
            return null;
        }
        return this.mAttrList.get(n);
    }

    public String getAttribute(String name) {
        if (!this.isTag() || this.mAttrList == null) {
            return null;
        }
        XMLAttribute attr = null;
        for (int i = 0; i < this.mAttrList.size(); ++i) {
            attr = this.mAttrList.get(i);
            if (attr.name.equals(name)) break;
            attr = null;
        }
        if (attr == null) {
            return null;
        }
        return attr.value;
    }

    public String toString() {
        return this.getText();
    }

    public int getShortcutNumber() {
        return this.shortcutNumber;
    }

    public void setShortcutNumber(int shortcutNumber) {
        this.shortcutNumber = shortcutNumber;
    }
}

