/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetDeviceCharacteristics;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetSyncFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.fs.util.SqlJetFileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetFile
implements ISqlJetFile {
    private static final boolean SQLJET_LOG_FILES = SqlJetUtility.getBoolSysProp("SQLJET_LOG_FILES", false);
    private static final boolean SQLJET_LOG_FILES_PERFORMANCE = SqlJetUtility.getBoolSysProp("SQLJET_LOG_FILES_PERFORMANCE", false);
    private static Logger filesLogger = Logger.getLogger("SQLJET_LOG_FILES");
    public static final int SQLJET_DEFAULT_SECTOR_SIZE = 512;
    private long timer_start = 0L;
    private long timer_elapsed = 0L;
    private static final Map<String, OpenFile> openFiles = new HashMap<String, OpenFile>();
    private SqlJetFileType fileType;
    private Set<SqlJetFileOpenPermission> permissions;
    private RandomAccessFile file;
    private File filePath;
    private String filePathResolved;
    private boolean noLock;
    private SqlJetLockType lockType = SqlJetLockType.NONE;
    private Map<SqlJetLockType, FileLock> locks = new ConcurrentHashMap<SqlJetLockType, FileLock>();
    private OpenFile openCount = null;
    private LockInfo lockInfo = null;
    private SqlJetFileLockManager fileLockManager;
    static final Set<SqlJetDeviceCharacteristics> noDeviceCharacteristircs = SqlJetUtility.noneOf(SqlJetDeviceCharacteristics.class);

    private static void OSTRACE(String format, Object ... args) {
        if (SQLJET_LOG_FILES) {
            SqlJetUtility.log(filesLogger, format, args);
        }
    }

    private long TIMER_ELAPSED() {
        return this.timer_elapsed;
    }

    private void TIMER_END() {
        if (SQLJET_LOG_FILES_PERFORMANCE) {
            this.timer_elapsed = System.nanoTime() - this.timer_start;
        }
    }

    private void TIMER_START() {
        if (SQLJET_LOG_FILES_PERFORMANCE) {
            this.timer_start = System.nanoTime();
        }
    }

    private String getpid() {
        return "thread ['" + Thread.currentThread().getName() + "]";
    }

    private String locktypeName(SqlJetLockType lockType) {
        return lockType != null ? lockType.name() : null;
    }

    SqlJetFile(SqlJetFileSystem fileSystem, RandomAccessFile file, File filePath, SqlJetFileType fileType, Set<SqlJetFileOpenPermission> permissions, boolean noLock) {
        this.file = file;
        this.filePath = filePath;
        this.filePathResolved = filePath.getAbsolutePath();
        this.fileType = fileType;
        this.permissions = EnumSet.copyOf(permissions);
        this.noLock = noLock;
        this.fileLockManager = new SqlJetFileLockManager(this.filePathResolved, file.getChannel());
        this.findLockInfo();
        SqlJetFile.OSTRACE("OPEN    %s\n", this.filePath);
    }

    @Override
    public SqlJetFileType getFileType() {
        return this.fileType;
    }

    @Override
    public synchronized Set<SqlJetFileOpenPermission> getPermissions() {
        HashSet<SqlJetFileOpenPermission> permissionsCopy = new HashSet<SqlJetFileOpenPermission>();
        for (SqlJetFileOpenPermission permission : this.permissions) {
            permissionsCopy.add(permission);
        }
        return permissionsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SqlJetException {
        if (null == this.file) {
            return;
        }
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            this.unlock(SqlJetLockType.NONE);
            if (!this.noLock && null != this.openCount && null != this.openCount.lockInfoMap && this.openCount.lockInfoMap.size() > 0) {
                for (LockInfo l : this.openCount.lockInfoMap.values()) {
                    if (l.sharedLockCount <= 0) continue;
                    this.openCount.pending.add(this.file);
                    return;
                }
            }
            this.releaseLockInfo();
            try {
                try {
                    this.file.close();
                }
                catch (IOException e) {
                    throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
                }
                Object var5_5 = null;
                this.file = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.file = null;
                throw throwable;
            }
        }
        if (this.filePath != null && this.permissions.contains((Object)SqlJetFileOpenPermission.DELETEONCLOSE) && !SqlJetFileUtil.deleteFile(this.filePath)) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_DELETE, String.format("Can't delete file '%s'", this.filePath.getPath()));
        }
        SqlJetFile.OSTRACE("CLOSE   %s\n", this.filePath);
    }

    @Override
    public synchronized int read(ISqlJetMemoryPointer buffer, int amount, long offset) throws SqlJetIOException {
        assert (amount > 0);
        assert (offset >= 0L);
        assert (buffer != null);
        assert (buffer.remaining() >= amount);
        assert (this.file != null);
        try {
            this.TIMER_START();
            int read = buffer.readFromFile(this.file, offset, amount);
            this.TIMER_END();
            SqlJetFile.OSTRACE("READ %s %5d %7d %d\n", this.filePath, read, offset, this.TIMER_ELAPSED());
            return read < 0 ? 0 : read;
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_READ, (Throwable)e);
        }
    }

    @Override
    public synchronized void write(ISqlJetMemoryPointer buffer, int amount, long offset) throws SqlJetIOException {
        assert (amount > 0);
        assert (offset >= 0L);
        assert (buffer != null);
        assert (buffer.remaining() >= amount);
        assert (this.file != null);
        try {
            this.TIMER_START();
            int write = buffer.writeToFile(this.file, offset, amount);
            this.TIMER_END();
            SqlJetFile.OSTRACE("WRITE %s %5d %7d %d\n", this.filePath, write, offset, this.TIMER_ELAPSED());
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_WRITE, (Throwable)e);
        }
    }

    @Override
    public synchronized void truncate(long size) throws SqlJetIOException {
        assert (size >= 0L);
        assert (this.file != null);
        try {
            this.file.setLength(size);
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_TRUNCATE, (Throwable)e);
        }
    }

    @Override
    public synchronized void sync(Set<SqlJetSyncFlags> syncFlags) throws SqlJetIOException {
        assert (this.file != null);
        try {
            SqlJetFile.OSTRACE("SYNC    %s\n", this.filePath);
            boolean syncMetaData = syncFlags != null && syncFlags.contains((Object)SqlJetSyncFlags.NORMAL);
            this.file.getChannel().force(syncMetaData);
        }
        catch (IOException e) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_FSYNC, (Throwable)e);
        }
    }

    @Override
    public synchronized long fileSize() throws SqlJetException {
        assert (this.file != null);
        try {
            return this.file.getChannel().size();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.IOERR, (Throwable)e);
        }
    }

    @Override
    public synchronized SqlJetLockType getLockType() {
        return this.lockType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean lock(SqlJetLockType lockType) throws SqlJetIOException {
        boolean bl;
        block49: {
            boolean bl2;
            block48: {
                boolean pendingLock3;
                block47: {
                    boolean sharedLock2;
                    block46: {
                        boolean bl3;
                        block45: {
                            boolean bl4;
                            block44: {
                                boolean bl5;
                                block43: {
                                    boolean bl6;
                                    block42: {
                                        assert (lockType != null);
                                        assert (this.file != null);
                                        if (this.noLock) {
                                            return false;
                                        }
                                        SqlJetFile.OSTRACE("LOCK    %s %s was %s(%s,%d) pid=%s\n", this.filePath, this.locktypeName(lockType), this.locktypeName(this.lockType), this.locktypeName(this.lockInfo.lockType), this.lockInfo.sharedLockCount, this.getpid());
                                        if (this.lockType.compareTo(lockType) > 0) {
                                            SqlJetFile.OSTRACE("LOCK    %s %s ok (already held)\n", this.filePath, this.locktypeName(lockType));
                                            return false;
                                        }
                                        assert (lockType != SqlJetLockType.PENDING);
                                        assert (this.lockType != SqlJetLockType.NONE || lockType == SqlJetLockType.SHARED);
                                        assert (lockType != SqlJetLockType.RESERVED || this.lockType == SqlJetLockType.SHARED);
                                        assert (this.lockInfo != null);
                                        try {
                                            try {
                                                Map<String, OpenFile> map = openFiles;
                                                synchronized (map) {
                                                    FileLock sharedLock2;
                                                    if (this.lockType != this.lockInfo.lockType && (SqlJetLockType.PENDING.compareTo(this.lockInfo.lockType) <= 0 || SqlJetLockType.SHARED.compareTo(lockType) < 0)) {
                                                        bl6 = false;
                                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 41, 10] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                                                        Object var8_9 = null;
                                                        break block42;
                                                    }
                                                    if (lockType == SqlJetLockType.SHARED && this.lockInfo.sharedLockCount > 0 && (this.lockInfo.lockType == SqlJetLockType.SHARED || this.lockInfo.lockType == SqlJetLockType.RESERVED)) {
                                                        this.lockType = SqlJetLockType.SHARED;
                                                        this.lockInfo.sharedLockCount++;
                                                        this.locks.put(SqlJetLockType.SHARED, this.lockInfo.sharedLock);
                                                        this.openCount.numLock++;
                                                        bl5 = true;
                                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 40, 10] lbl38 : MonitorExitStatement: MONITOREXIT : var2_2
                                                        break block43;
                                                    }
                                                    if (lockType == SqlJetLockType.SHARED || lockType == SqlJetLockType.EXCLUSIVE && this.lockType.compareTo(SqlJetLockType.PENDING) < 0) {
                                                        if (!this.locks.containsKey((Object)SqlJetLockType.PENDING)) {
                                                            FileLock pendingLock2 = this.fileLockManager.tryLock(0x40000000L, 1L, lockType == SqlJetLockType.SHARED);
                                                            if (null == pendingLock2) {
                                                                bl4 = false;
                                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 37, 38, 39, 10] lbl46 : MonitorExitStatement: MONITOREXIT : var2_2
                                                                break block44;
                                                            }
                                                            this.locks.put(SqlJetLockType.PENDING, pendingLock2);
                                                        }
                                                        if (lockType != SqlJetLockType.SHARED && this.lockInfo.sharedLockCount <= 1 && null != (sharedLock2 = this.locks.remove((Object)SqlJetLockType.SHARED))) {
                                                            sharedLock2.release();
                                                            this.lockInfo.sharedLock = null;
                                                        }
                                                    }
                                                    if (lockType == SqlJetLockType.SHARED) {
                                                        sharedLock2 = this.fileLockManager.tryLock(0x40000002L, 510L, true);
                                                        FileLock pendingLock3 = this.locks.get((Object)SqlJetLockType.PENDING);
                                                        if (null != pendingLock3) {
                                                            pendingLock3.release();
                                                            this.locks.remove((Object)SqlJetLockType.PENDING);
                                                        }
                                                        if (null == sharedLock2) {
                                                            bl3 = false;
                                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 34, 36, 10] lbl64 : MonitorExitStatement: MONITOREXIT : var2_2
                                                            break block45;
                                                        }
                                                        this.locks.put(SqlJetLockType.SHARED, sharedLock2);
                                                        this.lockType = SqlJetLockType.SHARED;
                                                        this.openCount.numLock++;
                                                        this.lockInfo.sharedLockCount = 1;
                                                        this.lockInfo.sharedLock = sharedLock2;
                                                    } else {
                                                        if (lockType == SqlJetLockType.EXCLUSIVE && this.lockInfo.sharedLockCount > 1) {
                                                            sharedLock2 = false;
                                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 33, 35, 10] lbl79 : MonitorExitStatement: MONITOREXIT : var2_2
                                                            break block46;
                                                        }
                                                        assert (SqlJetLockType.NONE != this.lockType);
                                                        switch (lockType) {
                                                            case RESERVED: {
                                                                FileLock reservedLock = this.fileLockManager.tryLock(0x40000001L, 1L, false);
                                                                if (null == reservedLock) {
                                                                    pendingLock3 = false;
                                                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 35, 21, 10, 11, 12] lbl89 : MonitorExitStatement: MONITOREXIT : var2_2
                                                                    break block47;
                                                                } else {
                                                                    this.locks.put(SqlJetLockType.RESERVED, reservedLock);
                                                                    break;
                                                                }
                                                            }
                                                            case EXCLUSIVE: {
                                                                FileLock exclusiveLock = this.fileLockManager.tryLock(0x40000002L, 510L, false);
                                                                if (null == exclusiveLock) {
                                                                    this.lockType = SqlJetLockType.PENDING;
                                                                    this.lockInfo.lockType = SqlJetLockType.PENDING;
                                                                    bl2 = false;
                                                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 19, 35, 10, 11, 13] lbl102 : MonitorExitStatement: MONITOREXIT : var2_2
                                                                    break block48;
                                                                } else {
                                                                    this.locks.put(SqlJetLockType.EXCLUSIVE, exclusiveLock);
                                                                    break;
                                                                }
                                                            }
                                                            default: {
                                                                assert (false);
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    this.lockType = lockType;
                                                    this.lockInfo.lockType = lockType;
                                                    bl = true;
                                                }
                                                break block49;
                                            }
                                            catch (IOException e) {
                                                throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_LOCK, (Throwable)e);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_17 = null;
                                            SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
                                            throw throwable;
                                        }
                                    }
                                    SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
                                    return bl6;
                                }
                                Object var8_10 = null;
                                SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
                                return bl5;
                            }
                            Object var8_11 = null;
                            SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
                            return bl4;
                        }
                        Object var8_12 = null;
                        SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
                        return bl3;
                    }
                    Object var8_13 = null;
                    SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
                    return sharedLock2;
                }
                Object var8_14 = null;
                SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
                return pendingLock3;
            }
            Object var8_15 = null;
            SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
            return bl2;
        }
        Object var8_16 = null;
        SqlJetFile.OSTRACE("LOCK    %s %s %s\n", this.filePath, this.locktypeName(lockType), this.lockType == lockType ? "ok" : "failed");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean unlock(SqlJetLockType lockType) throws SqlJetIOException {
        assert (lockType != null);
        assert (this.file != null);
        if (this.noLock) {
            return false;
        }
        SqlJetFile.OSTRACE("UNLOCK  %s %s was %s(%s,%s) pid=%s\n", this.filePath, this.locktypeName(lockType), this.locktypeName(this.lockType), this.locktypeName(this.lockInfo.lockType), this.lockInfo.sharedLockCount, this.getpid());
        assert (SqlJetLockType.SHARED.compareTo(lockType) >= 0);
        if (this.lockType.compareTo(lockType) <= 0) {
            return true;
        }
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            assert (this.lockInfo != null);
            assert (this.lockInfo.sharedLockCount > 0);
            try {
                if (SqlJetLockType.SHARED.compareTo(this.lockType) < 0) {
                    FileLock pendingLock;
                    FileLock reservedLock;
                    if (SqlJetLockType.SHARED == lockType) {
                        FileLock exclusiveLock = this.locks.get((Object)SqlJetLockType.EXCLUSIVE);
                        if (null != exclusiveLock) {
                            exclusiveLock.release();
                            this.locks.remove((Object)SqlJetLockType.EXCLUSIVE);
                        }
                        if (null == this.locks.get((Object)SqlJetLockType.SHARED)) {
                            FileLock sharedLock = this.fileLockManager.lock(0x40000002L, 510L, true);
                            if (null == sharedLock) {
                                return false;
                            }
                            this.locks.put(SqlJetLockType.SHARED, sharedLock);
                            this.lockInfo.sharedLock = sharedLock;
                        }
                    }
                    if (null != (reservedLock = this.locks.get((Object)SqlJetLockType.RESERVED))) {
                        reservedLock.release();
                        this.locks.remove((Object)SqlJetLockType.RESERVED);
                    }
                    if (null != (pendingLock = this.locks.get((Object)SqlJetLockType.PENDING))) {
                        pendingLock.release();
                        this.locks.remove((Object)SqlJetLockType.PENDING);
                    }
                    this.lockInfo.lockType = SqlJetLockType.SHARED;
                }
                if (lockType == SqlJetLockType.NONE) {
                    this.lockInfo.sharedLockCount--;
                    if (this.lockInfo.sharedLockCount == 0) {
                        this.lockInfo.sharedLockCount = 1;
                        for (FileLock l : this.locks.values()) {
                            l.release();
                        }
                        this.locks.clear();
                        this.lockInfo.sharedLockCount = 0;
                        this.lockInfo.lockType = SqlJetLockType.NONE;
                    }
                    this.openCount.numLock--;
                    assert (this.openCount.numLock >= 0);
                    if (this.openCount.numLock == 0 && null != this.openCount.pending && this.openCount.pending.size() > 0) {
                        for (RandomAccessFile f : this.openCount.pending) {
                            f.close();
                        }
                        this.openCount.pending.clear();
                    }
                }
                this.lockType = lockType;
            }
            catch (IOException e) {
                throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_LOCK, (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean checkReservedLock() {
        boolean bl;
        boolean reserved;
        block20: {
            boolean bl2;
            block18: {
                boolean bl3;
                block17: {
                    boolean bl4;
                    block16: {
                        boolean bl5;
                        block15: {
                            boolean bl6;
                            block14: {
                                reserved = false;
                                try {
                                    block19: {
                                        if (this.noLock) {
                                            bl6 = false;
                                            Object var7_7 = null;
                                            break block14;
                                        }
                                        if (null == this.file) {
                                            bl5 = false;
                                            break block15;
                                        }
                                        if (null == this.lockInfo) {
                                            bl4 = false;
                                            break block16;
                                        }
                                        Map<String, OpenFile> map = openFiles;
                                        synchronized (map) {
                                            FileLock reservedLock;
                                            if (SqlJetLockType.SHARED.compareTo(this.lockInfo.lockType) < 0) {
                                                bl3 = true;
                                                // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl20 : MonitorExitStatement: MONITOREXIT : var2_5
                                                break block17;
                                            }
                                            try {
                                                reservedLock = this.fileLockManager.tryLock(0x40000001L, 1L, false);
                                                if (null == reservedLock) {
                                                    reserved = true;
                                                    bl2 = true;
                                                    break block18;
                                                }
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                                break block19;
                                            }
                                            {
                                                reservedLock.release();
                                            }
                                        }
                                    }
                                    bl = false;
                                    break block20;
                                }
                                catch (Throwable throwable) {
                                    Object var7_13 = null;
                                    SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                                    throw throwable;
                                }
                            }
                            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                            return bl6;
                        }
                        Object var7_8 = null;
                        SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                        return bl5;
                    }
                    Object var7_9 = null;
                    SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                    return bl4;
                }
                Object var7_10 = null;
                SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
                return bl3;
            }
            Object var7_11 = null;
            SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
            return bl2;
        }
        Object var7_12 = null;
        SqlJetFile.OSTRACE("TEST WR-LOCK %s %b\n", this.filePath, reserved);
        return bl;
    }

    @Override
    public int sectorSize() {
        return 512;
    }

    @Override
    public Set<SqlJetDeviceCharacteristics> deviceCharacteristics() {
        return noDeviceCharacteristircs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void findLockInfo() {
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            LockInfo fileLockInfo;
            if (null == this.openCount) {
                OpenFile fileOpenCount = openFiles.get(this.filePathResolved);
                if (null != fileOpenCount) {
                    this.openCount = fileOpenCount;
                    this.openCount.numRef++;
                } else {
                    this.openCount = new OpenFile();
                    openFiles.put(this.filePathResolved, this.openCount);
                }
            }
            if (null != (fileLockInfo = (LockInfo)this.openCount.lockInfoMap.get(Thread.currentThread()))) {
                this.lockInfo = fileLockInfo;
                this.lockInfo.numRef++;
            } else {
                this.lockInfo = new LockInfo();
                this.openCount.lockInfoMap.put(Thread.currentThread(), this.lockInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockInfo() {
        Map<String, OpenFile> map = openFiles;
        synchronized (map) {
            if (null != this.lockInfo) {
                this.lockInfo.numRef--;
                if (0 == this.lockInfo.numRef) {
                    if (null != this.openCount) {
                        this.openCount.lockInfoMap.remove(Thread.currentThread());
                    }
                    this.lockInfo = null;
                }
            }
            if (null != this.openCount) {
                this.openCount.numRef--;
                if (0 == this.openCount.numRef) {
                    openFiles.remove(this.filePathResolved);
                    this.openCount = null;
                }
            }
        }
    }

    @Override
    public boolean isMemJournal() {
        return false;
    }

    private static class OpenFile {
        private int numRef = 1;
        private int numLock = 0;
        private Map<Thread, LockInfo> lockInfoMap = new ConcurrentHashMap<Thread, LockInfo>();
        private List<RandomAccessFile> pending = new ArrayList<RandomAccessFile>();

        private OpenFile() {
        }
    }

    private static class LockInfo {
        private SqlJetLockType lockType = SqlJetLockType.NONE;
        private int sharedLockCount = 0;
        private int numRef = 1;
        private FileLock sharedLock = null;

        private LockInfo() {
        }
    }
}

