/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.comparator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.loomchild.maligna.comparator.Diff;
import net.loomchild.maligna.coretypes.Alignment;

public class Comparator {
    public static Diff compare(List<Alignment> leftAlignmentList, List<Alignment> rightAlignmentList) {
        Diff diff;
        if (leftAlignmentList.size() > 0 && rightAlignmentList.size() > 0) {
            int[][] occurrenceArray = Comparator.createOccurenceArray(leftAlignmentList, rightAlignmentList);
            int[] indexArray = new int[leftAlignmentList.size()];
            for (int i = 0; i < indexArray.length; ++i) {
                indexArray[i] = occurrenceArray[i].length;
            }
            int bestLength = -1;
            int[] bestIndexArray = null;
            do {
                int length;
                if ((length = Comparator.length(indexArray, occurrenceArray)) < bestLength) continue;
                bestLength = length;
                bestIndexArray = Arrays.copyOf(indexArray, indexArray.length);
            } while (Comparator.next(indexArray, occurrenceArray));
            diff = Comparator.createDiff(leftAlignmentList, rightAlignmentList, bestIndexArray, occurrenceArray);
        } else {
            List<Alignment> commonList = Collections.emptyList();
            diff = new Diff(commonList, Collections.singletonList(leftAlignmentList), Collections.singletonList(rightAlignmentList));
        }
        return diff;
    }

    private static int[][] createOccurenceArray(List<Alignment> leftAlignmentList, List<Alignment> rightAlignmentList) {
        HashMap<Alignment, ArrayList<Integer>> rightOccurrenceMap = new HashMap<Alignment, ArrayList<Integer>>();
        int position = 0;
        for (Alignment alignment : rightAlignmentList) {
            ArrayList<Integer> occurrenceList = (ArrayList<Integer>)rightOccurrenceMap.get(alignment);
            if (occurrenceList == null) {
                occurrenceList = new ArrayList<Integer>();
            }
            occurrenceList.add(position);
            rightOccurrenceMap.put(alignment, occurrenceList);
            ++position;
        }
        int[][] occurrenceArray = new int[leftAlignmentList.size()][];
        int i = 0;
        for (Alignment alignment : leftAlignmentList) {
            int[] array;
            List list = (List)rightOccurrenceMap.get(alignment);
            if (list != null) {
                array = new int[list.size()];
                int k = 0;
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    int occurence;
                    array[k] = occurence = ((Integer)i$.next()).intValue();
                    ++k;
                }
            } else {
                array = new int[]{};
            }
            occurrenceArray[i] = array;
            ++i;
        }
        return occurrenceArray;
    }

    private static boolean next(int[] indexArray, int[][] occurrenceArray) {
        for (int i = indexArray.length - 1; i >= 0; --i) {
            int k;
            if (indexArray[i] <= 0) continue;
            for (k = i - 1; k >= 0 && indexArray[k] == occurrenceArray[k].length; --k) {
            }
            if (k >= 0 && occurrenceArray[k][indexArray[k]] >= occurrenceArray[i][indexArray[i] - 1]) continue;
            int n = i;
            indexArray[n] = indexArray[n] - 1;
            int position = occurrenceArray[i][indexArray[i]];
            for (int m = i + 1; m < indexArray.length; ++m) {
                int n2;
                for (n2 = 0; n2 < occurrenceArray[m].length && position > occurrenceArray[m][n2]; ++n2) {
                }
                if (n2 < occurrenceArray[m].length) {
                    position = occurrenceArray[m][n2];
                }
                indexArray[m] = n2;
            }
            return true;
        }
        return false;
    }

    private static int length(int[] indexArray, int[][] occurrenceArray) {
        int length = 0;
        for (int i = 0; i < indexArray.length; ++i) {
            if (indexArray[i] >= occurrenceArray[i].length) continue;
            ++length;
        }
        return length;
    }

    private static Diff createDiff(List<Alignment> leftAlignmentList, List<Alignment> rightAlignmentList, int[] indexArray, int[][] occurrenceArray) {
        ArrayList<Alignment> commonList = new ArrayList<Alignment>();
        ArrayList<List<Alignment>> leftList = new ArrayList<List<Alignment>>();
        ArrayList<List<Alignment>> rightList = new ArrayList<List<Alignment>>();
        int previousLeftPosition = 0;
        int previousRightPosition = 0;
        for (int i = 0; i < indexArray.length; ++i) {
            if (indexArray[i] >= occurrenceArray[i].length) continue;
            Alignment commonAlignment = leftAlignmentList.get(i);
            commonList.add(commonAlignment);
            int leftPosition = i;
            int rightPosition = occurrenceArray[i][indexArray[i]];
            if (leftPosition > previousLeftPosition || rightPosition > previousRightPosition) {
                ArrayList<Alignment> leftGroup = new ArrayList<Alignment>(leftAlignmentList.subList(previousLeftPosition, leftPosition));
                leftList.add(leftGroup);
                ArrayList<Alignment> rightGroup = new ArrayList<Alignment>(rightAlignmentList.subList(previousRightPosition, rightPosition));
                rightList.add(rightGroup);
            }
            previousLeftPosition = leftPosition + 1;
            previousRightPosition = rightPosition + 1;
        }
        return new Diff(commonList, leftList, rightList);
    }
}

