/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.PostgresqlCyclotis;
import org.silvestrislab.cyclotis.omegat.proj.ctx.ContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.IntContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;
import org.silvestrislab.cyclotis.omegat.tm.PropertiesStore;

public abstract class PostgresqlCyclotisTMX<T extends PrepareTMXEntry>
extends PostgresqlCyclotis<T> {
    protected PROPS_COLS_TYPE col_props;
    protected final PropertiesStore store;
    protected ContextMode contextMode;

    protected PostgresqlCyclotisTMX(Properties propList) throws SQLException, ClassNotFoundException {
        super(propList);
        this.store = new PropertiesStore(this, propList);
    }

    protected PostgresqlCyclotisTMX(PostgresqlCyclotisTMX ori) {
        super(ori);
        this.col_props = ori.col_props;
        this.store = ori.store;
        this.contextMode = ori.contextMode;
    }

    @Override
    protected void registerColumn(ResultSet set, Properties propList) throws SQLException {
        if (set.getString("column_name").equalsIgnoreCase("PROPS")) {
            String name = set.getString("udt_name").toUpperCase();
            if (name.startsWith("VARCHAR") || name.equals("TEXT")) {
                this.col_props = new TextColsType();
            } else if (name.equals("HSTORE")) {
                this.col_props = new HstoreColsType();
            } else if (name.equals("JSON")) {
                this.col_props = new JsonColsType();
            } else {
                PreparedStatement pColumnInfo = this.connection.prepareStatement("select attribute_name from INFORMATION_SCHEMA.ATTRIBUTES where udt_name = ? and udt_schema = ? and udt_catalog = current_catalog order by ordinal_position");
                pColumnInfo.setString(1, name.toLowerCase());
                pColumnInfo.setString(2, set.getString("udt_schema"));
                ResultSet set1 = pColumnInfo.executeQuery();
                ArrayList<String> attNames = new ArrayList<String>();
                while (set1.next()) {
                    attNames.add(set1.getString("attribute_name"));
                }
                this.col_props = new CompositeColsType(name, attNames.toArray(new String[0]));
            }
            this.logMessage("struct", "registerColumn: " + this + " .col_props = " + this.col_props);
        }
        if (set.getString("column_name").equalsIgnoreCase("CONTEXT")) {
            String type = set.getString("udt_name").toUpperCase();
            if (type.startsWith("INT")) {
                this.contextMode = IntContextMode.forProperties(propList);
            }
            if (type.startsWith("VARCHAR")) {
                this.contextMode = StringContextMode.forProperties(propList, set.getInt("character_maximum_length"));
            }
            if (type.startsWith("TEXT")) {
                this.contextMode = StringContextMode.forProperties(propList, Integer.MAX_VALUE);
            }
            if (type.startsWith("BPCHAR")) {
                this.contextMode = StringContextMode.forProperties(propList, -set.getInt("character_maximum_length"));
            }
            this.logMessage("struct", "Context mode is " + this.contextMode + " (type was " + type + ")");
        }
        super.registerColumn(set, propList);
    }

    @Override
    protected String getInsertFieldType(String name) {
        if (name.equalsIgnoreCase("props")) {
            return this.col_props.declaredType();
        }
        return "";
    }

    public void registerTranslation(T entryContents) throws Exception {
        this.logMessage("update", "Writing entry '" + ((PrepareTMXEntry)entryContents).source + "'");
        try {
            this.pInsert.setString(1, this.reformatText(((PrepareTMXEntry)entryContents).source, false));
            this.pInsert.setString(2, this.reformatText(((PrepareTMXEntry)entryContents).translation, false));
            int res = this.pInsert.executeUpdate();
            this.logEntry("search-results", entryContents, false);
            this.logMessage("update", "entry '" + ((PrepareTMXEntry)entryContents).source + "' updated :" + res);
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
    }

    @Override
    public StringBuffer entryToLogString(T entry, boolean detailed, boolean digest) {
        StringBuffer buf = detailed ? new StringBuffer("\t<TMX Entry author='" + ((PrepareTMXEntry)entry).creator + "' creation-date='" + LONG_LOG_DATE_FORMAT.format(new Date(((PrepareTMXEntry)entry).creationDate)) + "' changer = '" + ((PrepareTMXEntry)entry).changer + "' change-date='" + LONG_LOG_DATE_FORMAT.format(new Date(((PrepareTMXEntry)entry).changeDate)) + ">\n") : new StringBuffer("\t<TMX Entry>\n");
        if (!digest) {
            buf.append("\t\t<source>" + ((PrepareTMXEntry)entry).source + "</source>\n");
            buf.append("\t\t<target>" + ((PrepareTMXEntry)entry).translation + "</target>\n");
        } else {
            buf.append("\t\t<source digest='" + this.digest(((PrepareTMXEntry)entry).source) + "'>" + ((PrepareTMXEntry)entry).source + "</source>\n");
            buf.append("\t\t<target digest='" + this.digest(((PrepareTMXEntry)entry).translation) + "'>" + ((PrepareTMXEntry)entry).translation + "</target>\n");
        }
        buf.append("\t</TMX Entry>");
        return buf;
    }

    public static class CompositeColsType
    extends PROPS_COLS_TYPE {
        private String typeName;
        private String[] cols;

        public CompositeColsType(String name, String[] cols) {
            this.typeName = name;
            this.cols = cols;
        }

        @Override
        public String declaredType() {
            return this.typeName;
        }

        @Override
        public String write(List<TMXProp> properties) {
            StringBuffer buffer = new StringBuffer("(");
            for (String col0 : this.cols) {
                String value = "";
                for (TMXProp prop : properties) {
                    if (!prop.getType().equalsIgnoreCase(col0)) continue;
                    value = prop.getValue();
                }
                buffer.append(value).append(",");
            }
            buffer.setLength(buffer.length() - 1);
            System.out.println("Writing props = " + buffer);
            return buffer.append(")").toString();
        }

        @Override
        public List<TMXProp> read(Object properties) {
            Object[] attributes = null;
            if (properties instanceof Struct) {
                try {
                    attributes = ((Struct)properties).getAttributes();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String propsString = properties.toString();
                propsString = propsString.substring(1);
                propsString = propsString.substring(0, propsString.indexOf(")"));
                attributes = propsString.split(",");
            }
            ArrayList<TMXProp> props = new ArrayList<TMXProp>();
            if (attributes != null) {
                for (int i = 0; i < Math.min(attributes.length, this.cols.length); ++i) {
                    props.add(new TMXProp(this.cols[i], attributes[i].toString()));
                }
            }
            return props;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer("Composite type ").append(this.typeName).append("(");
            for (String col : this.cols) {
                buf.append(col).append(",");
            }
            return buf.toString();
        }
    }

    public static class HstoreColsType
    extends PROPS_COLS_TYPE {
        private static final Pattern HSTORE_PROP = Pattern.compile("\\\"(.+?)\\\"\\s*=>\\s*\\\"(.+?)\\\"");

        @Override
        public Map<String, String> write(List<TMXProp> properties) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TMXProp prop : properties) {
                map.put(prop.getType(), prop.getValue());
            }
            return map;
        }

        @Override
        public List<TMXProp> read(Object properties) {
            ArrayList<TMXProp> props = new ArrayList<TMXProp>();
            if (properties instanceof String) {
                Matcher matcher = HSTORE_PROP.matcher(properties.toString());
                while (matcher.find()) {
                    props.add(new TMXProp(matcher.group(1), matcher.group(2)));
                }
            }
            if (properties instanceof Map) {
                for (Map.Entry hme : ((Map)properties).entrySet()) {
                    props.add(new TMXProp((String)hme.getKey(), (String)hme.getValue()));
                }
            }
            return props;
        }
    }

    public static class JsonColsType
    extends PROPS_COLS_TYPE {
        private static final Pattern JSON_PROP = Pattern.compile("\\\"(.+?)\\\"\\s*:\\s*\\\"(.+?)\\\"");

        @Override
        public String write(List<TMXProp> properties) {
            StringBuffer buffer = new StringBuffer("{ ");
            for (TMXProp prop : properties) {
                buffer.append("\"" + prop.getType() + "\"").append(" : ").append("\"" + prop.getValue() + "\"").append(",");
            }
            buffer.replace(buffer.length() - 1, buffer.length(), "}");
            return buffer.toString();
        }

        @Override
        public List<TMXProp> read(Object properties) {
            ArrayList<TMXProp> props = new ArrayList<TMXProp>();
            Matcher matcher = JSON_PROP.matcher(properties.toString());
            while (matcher.find()) {
                props.add(new TMXProp(matcher.group(1), matcher.group(2)));
            }
            return props;
        }

        @Override
        public String declaredType() {
            return "json";
        }
    }

    public static class TextColsType
    extends PROPS_COLS_TYPE {
        @Override
        public String write(List<TMXProp> properties) {
            StringBuffer buffer = new StringBuffer("TABLE:");
            for (TMXProp prop : properties) {
                buffer.append(prop.getType()).append("=").append(prop.getValue()).append("&");
            }
            return buffer.toString();
        }

        @Override
        public List<TMXProp> read(Object properties) {
            ArrayList<TMXProp> props = new ArrayList<TMXProp>();
            String propStr = properties.toString();
            propStr = propStr.replace("TABLE:", "");
            for (String prop0 : propStr.split("&")) {
                String[] keyVal = prop0.split("=");
                props.add(new TMXProp(keyVal[0], keyVal[1]));
            }
            return props;
        }
    }

    public static abstract class PROPS_COLS_TYPE {
        public abstract Object write(List<TMXProp> var1);

        public abstract List<TMXProp> read(Object var1);

        public String declaredType() {
            return "";
        }

        public String toString() {
            return this.getClass().getName().substring(0, this.getClass().getName().indexOf("Cols"));
        }
    }
}

