/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import gen.core.filters.Filters;
import gen.core.project.RepositoryDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.omegat.core.data.ProjectException;
import org.omegat.core.segmentation.SRX;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.StringUtil;

public class ProjectProperties {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/.svn/**", "**/CVS/**", "**/.cvs/**", "**/desktop.ini", "**/Thumbs.db", "**/.DS_Store"};
    private String projectName;
    private final List<String> sourceRootExcludes = new ArrayList<String>();
    private List<RepositoryDefinition> repositories;
    private Language sourceLanguage;
    private Language targetLanguage;
    private Class<?> sourceTokenizer;
    private Class<?> targetTokenizer;
    private boolean sentenceSegmentingEnabled;
    private boolean supportDefaultTranslations;
    private boolean removeTags;
    private SRX projectSRX;
    private Filters projectFilters;
    private String externalCommand;
    protected File projectRootDir;
    protected ProjectPath sourceDir = new ProjectPath(true);
    protected ProjectPath targetDir = new ProjectPath(true);
    protected ProjectPath glossaryDir = new ProjectPath(true);
    protected ProjectPath writableGlossaryFile = new ProjectPath(false);
    protected ProjectPath tmDir = new ProjectPath(true);
    protected ProjectPath dictDir = new ProjectPath(true);

    public static List<String> getDefaultExcludes() {
        return Collections.unmodifiableList(Arrays.asList(DEFAULT_EXCLUDES));
    }

    protected ProjectProperties() {
    }

    public ProjectProperties(File projectDir) throws Exception {
        this.projectRootDir = projectDir;
        this.projectName = projectDir.getName();
        this.setSourceRoot(this.getProjectRoot() + "source" + File.separator);
        this.sourceRootExcludes.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        this.setTargetRoot(this.getProjectRoot() + "target" + File.separator);
        this.setGlossaryRoot(this.getProjectRoot() + "glossary" + File.separator);
        this.setWriteableGlossary(this.getProjectRoot() + "glossary" + File.separator + "glossary.txt");
        this.setTMRoot(this.getProjectRoot() + "tm" + File.separator);
        this.setDictRoot(this.getProjectRoot() + "dictionary" + File.separator);
        this.setSentenceSegmentingEnabled(true);
        this.setSupportDefaultTranslations(true);
        this.setRemoveTags(false);
        this.setSourceLanguage("EN-US");
        this.setTargetLanguage("EN-GB");
        this.loadProjectSRX();
        this.loadProjectFilters();
        this.setSourceTokenizer(PluginUtils.getTokenizerClassForLanguage(this.getSourceLanguage()));
        this.setTargetTokenizer(PluginUtils.getTokenizerClassForLanguage(this.getTargetLanguage()));
    }

    public String getTargetRoot() {
        return this.targetDir.getAsString();
    }

    public void setTargetRoot(String targetRoot) {
        this.targetDir.setRelativeOrAbsolute(targetRoot);
    }

    public ProjectPath getTargetDir() {
        return this.targetDir;
    }

    public String getGlossaryRoot() {
        return this.glossaryDir.getAsString();
    }

    public void setGlossaryRoot(String glossaryRoot) {
        this.glossaryDir.setRelativeOrAbsolute(glossaryRoot);
    }

    public ProjectPath getGlossaryDir() {
        return this.glossaryDir;
    }

    public ProjectPath getWritableGlossaryFile() {
        return this.writableGlossaryFile;
    }

    public String getWriteableGlossary() {
        return this.writableGlossaryFile.getAsString();
    }

    public String getWriteableGlossaryDir() {
        ProjectPath dir = new ProjectPath(true);
        dir.setRelativeOrAbsolute(this.writableGlossaryFile.getAsFile().getParent());
        return dir.getAsString();
    }

    public void setWriteableGlossary(String writeableGlossaryFile) {
        this.writableGlossaryFile.setRelativeOrAbsolute(writeableGlossaryFile);
    }

    public boolean isDefaultWriteableGlossaryFile() {
        return this.computeDefaultWriteableGlossaryFile().equals(this.writableGlossaryFile.getAsString());
    }

    public String computeDefaultWriteableGlossaryFile() {
        String glossaryDir = this.getGlossaryRoot();
        if (glossaryDir.startsWith(this.getProjectRoot())) {
            return glossaryDir + "glossary.txt";
        }
        return glossaryDir + this.projectName + "-glossary.txt";
    }

    public ProjectPath getTmDir() {
        return this.tmDir;
    }

    public String getTMRoot() {
        return this.tmDir.getAsString();
    }

    public void setTMRoot(String tmRoot) {
        this.tmDir.setRelativeOrAbsolute(tmRoot);
    }

    public String getTMOtherLangRoot() {
        return this.tmDir.getAsString() + "tmx2source" + '/';
    }

    public String getTMAutoRoot() {
        return this.tmDir.getAsString() + "auto" + '/';
    }

    public ProjectPath getDictDir() {
        return this.dictDir;
    }

    public String getDictRoot() {
        return this.dictDir.getAsString();
    }

    public void setDictRoot(String dictRoot) {
        this.dictDir.setRelativeOrAbsolute(dictRoot);
    }

    public String getDictRootRelative() {
        return this.dictDir.getAsString();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectRoot() {
        String p = this.projectRootDir.getPath().replace('\\', '/');
        if (!p.endsWith("/")) {
            p = p + '/';
        }
        return p;
    }

    public File getProjectRootDir() {
        return this.projectRootDir;
    }

    protected void setProjectRoot(String projectRoot) {
        this.projectRootDir = new File(projectRoot);
    }

    public String getProjectInternal() {
        return this.getProjectRoot() + "omegat" + '/';
    }

    public File getProjectInternalDir() {
        return new File(this.projectRootDir, "omegat");
    }

    public String getProjectInternalRelative() {
        return "omegat/";
    }

    public String getSourceRoot() {
        return this.sourceDir.getAsString();
    }

    public void setSourceRoot(String sourceRoot) {
        if (!StringUtil.isEmpty(sourceRoot)) {
            this.sourceDir.setRelativeOrAbsolute(sourceRoot);
        }
    }

    public void setSourceRootRelative(String sourceRootRelative) {
        if (!StringUtil.isEmpty(sourceRootRelative)) {
            this.sourceDir.setRelativeOrAbsolute(sourceRootRelative);
        }
    }

    public ProjectPath getSourceDir() {
        return this.sourceDir;
    }

    public List<String> getSourceRootExcludes() {
        return this.sourceRootExcludes;
    }

    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(Language sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = new Language(sourceLanguage);
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(Language targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public void setTargetLanguage(String targetLanguage) {
        this.targetLanguage = new Language(targetLanguage);
    }

    public Class<?> getSourceTokenizer() {
        if (this.sourceTokenizer == null) {
            Class<?> cls = PluginUtils.getTokenizerClassForLanguage(this.getSourceLanguage());
            this.setSourceTokenizer(cls);
        }
        return this.sourceTokenizer;
    }

    public void setSourceTokenizer(Class<?> sourceTokenizer) {
        this.sourceTokenizer = sourceTokenizer;
    }

    public Class<?> getTargetTokenizer() {
        return this.targetTokenizer;
    }

    public void setTargetTokenizer(Class<?> targetTokenizer) {
        this.targetTokenizer = targetTokenizer;
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingEnabled;
    }

    public void setSentenceSegmentingEnabled(boolean sentenceSegmentingEnabled) {
        this.sentenceSegmentingEnabled = sentenceSegmentingEnabled;
    }

    public boolean isSupportDefaultTranslations() {
        return this.supportDefaultTranslations;
    }

    public void setSupportDefaultTranslations(boolean supportDefaultTranslations) {
        this.supportDefaultTranslations = supportDefaultTranslations;
    }

    public boolean isRemoveTags() {
        return this.removeTags;
    }

    public void setRemoveTags(boolean removeTags) {
        this.removeTags = removeTags;
    }

    public boolean hasRepositories() {
        return this.repositories != null && !this.repositories.isEmpty();
    }

    public List<RepositoryDefinition> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<RepositoryDefinition> repositories) {
        this.repositories = repositories;
    }

    public SRX getProjectSRX() {
        return this.projectSRX;
    }

    public void setProjectSRX(SRX projectSRX) {
        this.projectSRX = projectSRX;
    }

    public void loadProjectSRX() {
        this.projectSRX = SRX.loadSRX(new File(this.getProjectInternal(), "segmentation.conf"));
    }

    public Filters getProjectFilters() {
        return this.projectFilters;
    }

    public void setProjectFilters(Filters projectFilters) {
        this.projectFilters = projectFilters;
    }

    public void loadProjectFilters() throws IOException {
        this.projectFilters = FilterMaster.loadConfig(new File(this.getProjectInternal(), "filters.xml"));
    }

    public String getExternalCommand() {
        return this.externalCommand;
    }

    public void setExternalCommand(String command) {
        this.externalCommand = command;
    }

    public boolean isProjectValid() {
        boolean returnValue;
        try {
            this.verifyProject();
            returnValue = true;
        }
        catch (ProjectException ex) {
            returnValue = false;
        }
        return returnValue;
    }

    public void verifyProject() throws ProjectException {
        String srcDir = this.getSourceRoot();
        File src = new File(srcDir);
        if (!src.exists()) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_SOURCE_FOLDER"), srcDir));
        }
        String tgtDir = this.getTargetRoot();
        File tgt = new File(tgtDir);
        if (!tgt.exists()) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_TARGET_FOLDER"), tgtDir));
        }
        String glsDir = this.getGlossaryRoot();
        File gls = new File(glsDir);
        if (!gls.exists()) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_GLOSSARY_FOLDER"), glsDir));
        }
        String wGlsDir = this.getWriteableGlossaryDir();
        if (!wGlsDir.contains(this.getGlossaryRoot())) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_W_GLOSSARY"), glsDir));
        }
        String tmxDir = this.getTMRoot();
        File tmx = new File(tmxDir);
        if (!tmx.exists()) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_TM_FOLDER"), tmxDir));
        }
        File dict = new File(this.getDictRoot());
        if (!dict.exists() && this.getDictRoot().equals(this.getProjectRoot() + "dictionary" + '/')) {
            dict.mkdirs();
        }
    }

    public void autocreateDirectories() {
        this.autocreateOneDirectory(this.getProjectInternalDir());
        this.autocreateOneDirectory(this.sourceDir.getAsFile());
        this.autocreateOneDirectory(this.targetDir.getAsFile());
        this.autocreateOneDirectory(this.glossaryDir.getAsFile());
        this.autocreateOneDirectory(this.tmDir.getAsFile());
        this.autocreateOneDirectory(this.dictDir.getAsFile());
    }

    private void autocreateOneDirectory(File dir) {
        if (!dir.exists()) {
            Log.logInfoRB("CT_AUTOCREATE_DIRECTORY", dir);
            dir.mkdirs();
        }
    }

    public final class ProjectPath {
        private final boolean isDirectory;
        private File fs;
        private String underRoot;

        public ProjectPath(boolean isDirectory) {
            this.isDirectory = isDirectory;
        }

        public void setRelativeOrAbsolute(String path) {
            this.underRoot = null;
            if (FileUtil.isRelative(path)) {
                Path p = ProjectProperties.this.projectRootDir == null ? Paths.get(path, new String[0]) : ProjectProperties.this.projectRootDir.toPath().resolve(path);
                this.fs = p.normalize().toFile();
                if (!path.contains("..")) {
                    this.underRoot = path.replace('\\', '/');
                    if (this.isDirectory && !this.underRoot.endsWith("/")) {
                        this.underRoot = this.underRoot + '/';
                    }
                }
            } else {
                this.fs = new File(FileUtil.absoluteForSystem(path, Platform.getOsType()));
                try {
                    String p = FileUtil.computeRelativePath(ProjectProperties.this.projectRootDir, this.fs);
                    if (!p.contains("..")) {
                        this.underRoot = p.replace('\\', '/');
                        if (this.isDirectory && !this.underRoot.endsWith("/")) {
                            this.underRoot = this.underRoot + '/';
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public File getAsFile() {
            return this.fs;
        }

        public String getAsString() {
            String p = this.fs.getPath().replace('\\', '/');
            if (this.isDirectory && !p.endsWith("/")) {
                p = p + '/';
            }
            return p;
        }

        public boolean isUnderRoot() {
            return this.underRoot != null;
        }

        public String getUnderRoot() {
            return this.underRoot;
        }
    }
}

