/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;
import org.omegat.core.dictionaries.DictionaryData;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class StarDict
implements IDictionaryFactory {
    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".ifo");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return this.loadDict(file, new Language(Locale.getDefault()));
    }

    @Override
    public IDictionary loadDict(File file, Language language) throws Exception {
        return new StarDictDict(file, language);
    }

    static class StarDictDict
    implements IDictionary {
        private final Language language;
        private int idxoffsetbits = 32;
        private final String dictName;
        private final DictType dictType;
        private final String dataFile;
        protected final DictionaryData<Entry> data;

        StarDictDict(File ifoFile, Language language) throws Exception {
            String bitsString;
            this.language = language;
            Map<String, String> header = this.readIFO(ifoFile);
            String version = header.get("version");
            if (!"2.4.2".equals(version) && !"3.0.0".equals(version)) {
                throw new Exception("Invalid version of dictionary: " + version);
            }
            String sametypesequence = header.get("sametypesequence");
            if (!("g".equals(sametypesequence) || "m".equals(sametypesequence) || "x".equals(sametypesequence) || "h".equals(sametypesequence))) {
                throw new Exception("Invalid type of dictionary: " + sametypesequence);
            }
            if ("3.0.0".equals(version) && (bitsString = header.get("idxoffsetbits")) != null) {
                this.idxoffsetbits = Integer.parseInt(bitsString);
            }
            if (this.idxoffsetbits != 32) {
                throw new Exception("StarDict dictionaries with idxoffsetbits=64 are not supported.");
            }
            String f = ifoFile.getPath();
            if (f.endsWith(".ifo")) {
                f = f.substring(0, f.length() - ".ifo".length());
            }
            this.dictName = f;
            try {
                this.dataFile = this.getFile(".dict.dz", ".dict").get().getPath();
                this.dictType = this.dataFile.endsWith(".dz") ? DictType.DICTZIP : DictType.DICTFILE;
            }
            catch (NoSuchElementException ex) {
                throw new FileNotFoundException("No .dict.dz or .dict files were found for " + this.dictName);
            }
            try {
                this.data = this.loadData(this.getFile(".idx.gz", ".idx").get());
            }
            catch (NoSuchElementException ex) {
                throw new FileNotFoundException("No .idx file could be found");
            }
        }

        private Optional<File> getFile(String ... suffixes) {
            return Stream.of(suffixes).map(suff -> new File(this.dictName + suff)).filter(f -> f.isFile()).findFirst();
        }

        private DictionaryData<Entry> loadData(File idxFile) throws IOException {
            InputStream is = new FileInputStream(idxFile);
            if (idxFile.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is, 8192);
            }
            DictionaryData<Entry> newData = new DictionaryData<Entry>(this.language);
            try (DataInputStream idx = new DataInputStream(new BufferedInputStream(is));
                 ByteArrayOutputStream mem = new ByteArrayOutputStream();){
                int b;
                while ((b = idx.read()) != -1) {
                    if (b == 0) {
                        String key = new String(mem.toByteArray(), 0, mem.size(), StandardCharsets.UTF_8);
                        mem.reset();
                        int bodyOffset = idx.readInt();
                        int bodyLength = idx.readInt();
                        newData.add(key, new Entry(bodyOffset, bodyLength));
                        continue;
                    }
                    mem.write(b);
                }
            }
            is.close();
            newData.done();
            return newData;
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) throws Exception {
            return this.data.lookUp(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), ((Entry)e.getValue()).getArticle())).collect(Collectors.toList());
        }

        @Override
        public List<DictionaryEntry> readArticlesPredictive(String word) {
            return this.data.lookUpPredictive(word).stream().map(e -> new DictionaryEntry((String)e.getKey(), ((Entry)e.getValue()).getArticle())).collect(Collectors.toList());
        }

        private synchronized String readArticle(int start, int len) {
            switch (this.dictType) {
                case DICTFILE: {
                    return this.readDictArticleText(start, len);
                }
                case DICTZIP: {
                    return this.readDictZipArticleText(start, len);
                }
            }
            throw new RuntimeException("Unknown StarDict dictionary type: " + (Object)((Object)this.dictType));
        }

        private String readDictArticleText(int start, int len) {
            String result = null;
            try (FileInputStream in = new FileInputStream(this.dataFile);){
                long moved2;
                byte[] data = new byte[len];
                long moved = in.skip(start);
                if (moved < (long)start && (moved2 = in.skip((long)start - moved)) < (long)start - moved) {
                    throw new IOException("Cannot seek dictionary.");
                }
                int readLen = in.read(data);
                result = new String(data, 0, readLen, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            return result;
        }

        private String readDictZipArticleText(int start, int len) {
            String result = null;
            try (DictZipInputStream din = new DictZipInputStream(new RandomAccessInputStream(this.dataFile, "r"));){
                din.seek((long)start);
                byte[] data = new byte[len];
                din.readFully(data);
                result = new String(data, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Log.log(e);
            }
            return result;
        }

        private Map<String, String> readIFO(File ifoFile) throws Exception {
            TreeMap<String, String> result = new TreeMap<String, String>();
            try (BufferedReader rd = Files.newBufferedReader(ifoFile.toPath(), StandardCharsets.UTF_8);){
                String line;
                String first = rd.readLine();
                if (!"StarDict's dict ifo file".equals(first)) {
                    throw new Exception("Invalid header of .ifo file: " + first);
                }
                while ((line = rd.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    int pos = line.indexOf(61);
                    if (pos < 0) {
                        throw new Exception("Invalid format of .ifo file: " + line);
                    }
                    result.put(line.substring(0, pos), line.substring(pos + 1));
                }
            }
            return result;
        }

        class Entry {
            private volatile String cache;
            private final int start;
            private final int len;

            Entry(int start, int len) {
                this.start = start;
                this.len = len;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getArticle() {
                String article = this.cache;
                if (article == null) {
                    Entry entry = this;
                    synchronized (entry) {
                        article = this.cache;
                        if (article == null) {
                            article = this.cache = this.loadArticle();
                        }
                    }
                }
                return article;
            }

            private String loadArticle() {
                return StarDictDict.this.readArticle(this.start, this.len).replace("\n", "<br>");
            }
        }
    }

    private static enum DictType {
        DICTZIP,
        DICTFILE;

    }
}

