/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Window;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.core.machinetranslators.YTPPostResponse;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;
import org.xml.sax.InputSource;

public class YandexTranslate
extends BaseTranslate {
    public static final int ERR_OK = 200;
    public static final int ERR_KEY_INVALID = 401;
    public static final int ERR_KEY_BLOCKED = 402;
    public static final int ERR_DAILY_REQ_LIMIT_EXCEEDED = 403;
    public static final int ERR_DAILY_CHAR_LIMIT_EXCEEDED = 404;
    public static final int ERR_TEXT_TOO_LONG = 413;
    public static final int ERR_UNPROCESSABLE_TEXT = 422;
    public static final int ERR_LANG_NOT_SUPPORTED = 501;
    private static final String PROPERTY_API_KEY = "yandex.api.key";
    protected static final String USER_AGENT = "Mozilla/5.0";
    protected static final String GT_URL = "https://translate.yandex.net/api/v1.5/tr/translate";

    @Override
    protected String getPreferenceName() {
        return "allow_yandex_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_YANDEX");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String mvYandexKey = this.getCredential(PROPERTY_API_KEY);
        if (mvYandexKey.isEmpty()) {
            return "";
        }
        String lvSourceLang = sLang.getLanguageCode().substring(0, 2).toLowerCase(Locale.ENGLISH);
        String lvTargetLang = tLang.getLanguageCode().substring(0, 2).toLowerCase(Locale.ENGLISH);
        String lvShorText = text.length() > 10000 ? text.substring(0, 9999) + "\u2026" : text;
        String prev = this.getFromCache(sLang, tLang, lvShorText);
        if (prev != null) {
            return prev;
        }
        TreeMap<String, String> p = new TreeMap<String, String>();
        p.put("key", mvYandexKey);
        p.put("lang", lvSourceLang + '-' + lvTargetLang);
        p.put("text", lvShorText);
        YTPPostResponse response = this.requestTranslate(p);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        switch (response.code) {
            case 200: {
                break;
            }
            case 401: {
                return response.code + ": " + OStrings.getString("MT_ENGINE_YANDEX_INVALID_KEY");
            }
            case 402: {
                return response.code + ": " + OStrings.getString("MT_ENGINE_YANDEX_API_BLOCKED");
            }
            case 403: {
                return response.code + ": " + OStrings.getString("MT_ENGINE_YANDEX_DAILY_LIMIT_DETECT");
            }
            case 404: {
                return response.code + ": " + OStrings.getString("MT_ENGINE_YANDEX_DAILY_LIMIT_VOLUME");
            }
            case 413: {
                return response.code + ": " + OStrings.getString("MT_ENGINE_YANDEX_MAZ_SIZE");
            }
            case 422: {
                return response.code + ": " + OStrings.getString("MT_ENGINE_YANDEX_TRANSLATION_NOT_POSSIBLE");
            }
            case 501: {
                return response.code + ": " + OStrings.getString("MT_ENGINE_YANDEX_DIRECTION_NOT_SUPPORTED");
            }
        }
        XPath xPathText = xPathFactory.newXPath();
        String pathText = "/Translation[@code='200']/text";
        String result = xPathText.evaluate(pathText, new InputSource(new StringReader(response.response)));
        this.putToCache(sLang, tLang, lvShorText, result);
        return result;
    }

    protected YTPPostResponse requestTranslate(Map params) throws Exception {
        YTPPostResponse response = new YTPPostResponse();
        try {
            response.response = WikiGet.post(GT_URL, params);
            response.code = 200;
        }
        catch (WikiGet.ResponseError ex) {
            response.response = null;
            response.code = ex.code;
        }
        return response;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                String key = this.panel.valueField1.getText().trim();
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                YandexTranslate.this.setCredential(YandexTranslate.PROPERTY_API_KEY, key, temporary);
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_YANDEX_API_KEY_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_API_KEY));
        dialog.panel.valueLabel2.setVisible(false);
        dialog.panel.valueField2.setVisible(false);
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_API_KEY));
        dialog.show();
    }
}

