/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

public class Entity {
    private boolean internal;
    private boolean parameter;
    private String name;
    private String originalName;
    private String value;
    private String publicId;
    private String systemId;

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isParameter() {
        return this.parameter;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getValue() {
        return this.value;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    private void setName(String name) {
        this.originalName = name;
        if (name.codePointAt(0) == 37) {
            this.parameter = true;
            this.name = name.substring(name.offsetByCodePoints(0, 1));
        } else {
            this.parameter = false;
            this.name = name;
        }
    }

    public Entity(String name, String value) {
        this.internal = true;
        this.setName(name);
        this.value = value;
    }

    public Entity(String name, String publicId, String systemId) {
        this.internal = false;
        this.setName(name);
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("<!ENTITY");
        if (this.parameter) {
            res.append(" %");
        }
        res.append(" ");
        res.append(this.name);
        if (this.internal) {
            res.append(" \"" + this.value + "\"");
        } else {
            if (this.publicId != null) {
                res.append(" PUBLIC \"" + this.publicId + "\"");
            }
            res.append(" SYSTEM \"" + this.systemId + "\"");
        }
        res.append(">");
        return res.toString();
    }
}

