/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import java.awt.Desktop;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.Core;
import org.omegat.gui.glossary.taas.BrowseTaasCollectionsController;
import org.omegat.gui.glossary.taas.SelectDomainController;
import org.omegat.gui.glossary.taas.TaaSPlugin;
import org.omegat.gui.glossary.taas.TaaSPreferencesPanel;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.IPreferencesController;
import org.omegat.gui.preferences.view.GlossaryPreferencesController;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class TaaSPreferencesController
extends BasePreferencesController {
    private static final String TAAS_KEY_URL = "https://term.tilde.com/account/keys/create?system=omegaT";
    private TaaSPreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_TAAS");
    }

    private void initGui() {
        this.panel = new TaaSPreferencesPanel();
        this.panel.getKeyButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(URI.create(TAAS_KEY_URL));
            }
            catch (Exception ex) {
                JOptionPane.showConfirmDialog(this.panel, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
            }
        });
        final Timer timer = new Timer(500, e -> {
            this.persistApiKey();
            this.updateEnabledness();
        });
        timer.setRepeats(false);
        this.panel.apiKeyTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                if (((TaaSPreferencesController)TaaSPreferencesController.this).panel.apiKeyTextField.hasFocus()) {
                    timer.restart();
                }
            }
        });
        this.panel.temporaryCheckBox.addActionListener(e -> this.persistApiKey());
        this.panel.selectDomainButton.addActionListener(e -> SelectDomainController.show());
        this.panel.browseCollectionsButton.addActionListener(e -> BrowseTaasCollectionsController.show());
        this.updateEnabledness();
    }

    private void persistApiKey() {
        try {
            String key = this.panel.apiKeyTextField.getText();
            boolean temporary = this.panel.temporaryCheckBox.isSelected();
            TaaSPlugin.getClient().setApiKey(key, temporary);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void updateEnabledness() {
        boolean enabled = TaaSPlugin.getClient().isAllowed();
        this.panel.messagePanel.setVisible(!enabled);
        this.panel.lookupCheckBox.setEnabled(enabled);
        this.panel.selectDomainButton.setEnabled(enabled);
        this.panel.browseCollectionsButton.setEnabled(enabled && Core.getProject().isProjectLoaded());
    }

    @Override
    protected void initFromPrefs() {
        this.panel.temporaryCheckBox.setSelected(TaaSPlugin.getClient().isApiKeyStoredTemporarily());
        this.panel.apiKeyTextField.setText(TaaSPlugin.getClient().getApiKey());
        this.panel.lookupCheckBox.setSelected(Preferences.isPreference("taas_lookup"));
    }

    @Override
    public void restoreDefaults() {
        this.panel.temporaryCheckBox.setSelected(TaaSPlugin.getClient().isApiKeyStoredTemporarily());
        this.panel.apiKeyTextField.setText(TaaSPlugin.getClient().getApiKey());
        this.panel.lookupCheckBox.setSelected(false);
    }

    @Override
    public void persist() {
        this.persistApiKey();
        Preferences.setPreference("taas_lookup", this.panel.lookupCheckBox.isSelected());
    }

    @Override
    public Class<? extends IPreferencesController> getParentViewClass() {
        return GlossaryPreferencesController.class;
    }
}

