/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.Language;
import org.omegat.util.TMXProp;

public class AlignFilesMemory
implements IBrowsableMemory {
    private String name;
    private List<PrepareTMXEntry> entries;

    public AlignFilesMemory(Properties config) {
        this.name = config.getProperty("name");
        if (this.name == null) {
            this.name = config.getProperty("source");
        }
        final HashMap entriesMap = new HashMap();
        FilterMaster master = Core.getFilterMaster();
        IParseCallback parseCallback1 = new IParseCallback(){

            @Override
            public void linkPrevNextSegments() {
            }

            @Override
            public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, IFilter filter) {
                this.addEntry(id, source, translation, isFuzzy, comment, null, filter, null);
            }

            @Override
            public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                PrepareTMXEntry entry = new PrepareTMXEntry();
                entry.source = source;
                entry.translation = translation;
                entry.note = comment;
                if (id == null) {
                    id = path;
                } else if (path != null) {
                    id = id + "/" + path;
                }
                entriesMap.put(id, entry);
            }

            @Override
            public void addEntryWithProperties(String id, String source, String translation, boolean isFuzzy, String[] props, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                PrepareTMXEntry entry = new PrepareTMXEntry();
                entry.source = source;
                entry.translation = translation;
                if (id == null) {
                    id = path;
                } else if (path != null) {
                    id = id + "/" + path;
                }
                entry.otherProperties = new ArrayList<TMXProp>(props.length / 2);
                for (int i = 0; i < props.length / 2; ++i) {
                    entry.otherProperties.add(new TMXProp(props[i * 2], props[i * 2 + 1]));
                }
                entriesMap.put(id, entry);
            }
        };
        try {
            master.loadFile(config.getProperty("source"), new FilterContext(Core.getProject().getProjectProperties()), parseCallback1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        IParseCallback parseCallback2 = new IParseCallback(){

            @Override
            public void linkPrevNextSegments() {
            }

            @Override
            public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, IFilter filter) {
                this.addEntry(id, source, translation, isFuzzy, comment, null, filter, null);
            }

            @Override
            public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                if (id == null) {
                    id = path;
                } else if (path != null) {
                    id = id + "/" + path;
                }
                PrepareTMXEntry entry = (PrepareTMXEntry)entriesMap.get(id);
                if (entry != null) {
                    entry.translation = source;
                }
            }

            @Override
            public void addEntryWithProperties(String id, String source, String translation, boolean isFuzzy, String[] props, String path, IFilter filter, List<ProtectedPart> protectedParts) {
                this.addEntry(id, source, translation, isFuzzy, null, path, filter, protectedParts);
            }
        };
        try {
            master.loadFile(config.getProperty("target"), new FilterContext(Core.getProject().getProjectProperties()), parseCallback2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.entries = new ArrayList(entriesMap.values());
    }

    @Override
    public String getProviderName() {
        return "Aligned files";
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    public List<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) {
        return Collections.unmodifiableList(this.entries);
    }

    public List<PrepareTMXEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }
}

