/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.lucene;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.lucene.NgramAnalyzer;
import org.omegat.core.search.SearchExpression;
import org.omegat.util.Language;

public class LuceneReader
implements IBrowsableMemory {
    private final NgramAnalyzer analyzer = new NgramAnalyzer();
    private IndexReader indexReader;
    private IndexSearcher searcher;
    private String name;
    private static final Pattern LITTERAL = Pattern.compile("(?<!\\\\)[^\\\\\\(\\)\\{\\}\\[\\]\\+\\-\\*]{4}");

    public LuceneReader(Properties prop) throws IOException {
        this(new File(prop.getProperty("dir")));
    }

    public LuceneReader(File indexDirectory) throws IOException {
        System.err.println("Reading Lucene : " + indexDirectory);
        if (!indexDirectory.isDirectory()) {
            indexDirectory = indexDirectory.getParentFile();
        }
        this.name = indexDirectory.getPath();
        this.indexReader = DirectoryReader.open((Directory)FSDirectory.open((Path)indexDirectory.toPath()));
        this.searcher = new IndexSearcher(this.indexReader);
        File stopFile = new File(indexDirectory, "stop");
        if (stopFile.exists()) {
            this.analyzer.loadstopNgrams(stopFile.getPath());
        }
    }

    @Override
    public String getProviderName() {
        return "Lucene";
    }

    @Override
    public String getMemoryName() {
        return this.name;
    }

    private BooleanQuery buildQuery(String text, BooleanClause.Occur occur) throws IOException {
        BooleanQuery query = new BooleanQuery();
        TokenStream queryTokenStream = this.analyzer.tokenStream("src", new StringReader(text));
        CharTermAttribute termAtt = (CharTermAttribute)queryTokenStream.addAttribute(CharTermAttribute.class);
        queryTokenStream.reset();
        HashSet<String> terms = new HashSet<String>();
        while (queryTokenStream.incrementToken()) {
            terms.add(termAtt.toString().toLowerCase());
        }
        for (String current : terms) {
            Term t = new Term("src", current);
            query.add((Query)new TermQuery(t), occur);
        }
        queryTokenStream.end();
        queryTokenStream.close();
        return query;
    }

    private Iterable<PrepareTMXEntry> executeQuery(BooleanQuery query, int maxCount) throws IOException {
        final TopScoreDocCollector topCollector = TopScoreDocCollector.create((int)maxCount);
        this.searcher.search((Query)query, (Collector)topCollector);
        return () -> new Iterator<PrepareTMXEntry>(){
            private ScoreDoc[] sdocs;
            private int pos;
            {
                this.sdocs = topCollector.topDocs().scoreDocs;
                this.pos = 0;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.sdocs.length;
            }

            @Override
            public PrepareTMXEntry next() {
                try {
                    Document doc = LuceneReader.this.searcher.doc(this.sdocs[this.pos++].doc);
                    return LuceneReader.this.toEntry(doc);
                }
                catch (Exception cie) {
                    throw new RuntimeException(cie);
                }
            }
        };
    }

    @Override
    public Iterable<PrepareTMXEntry> findMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        BooleanQuery query = this.buildQuery(text, BooleanClause.Occur.SHOULD);
        int minShould = query.clauses().size() * minScore / 200;
        if (minShould > 1) {
            query.setMinimumNumberShouldMatch(minShould);
        }
        return this.executeQuery(query, maxCount);
    }

    @Override
    public Iterable<PrepareTMXEntry> getEntries() throws CorruptIndexException, IOException {
        return () -> new Iterator<PrepareTMXEntry>(){
            private int pos = 0;
            private int max = LuceneReader.access$000(LuceneReader.this).maxDoc() - 1;
            private Bits bits = null;
            {
                if (LuceneReader.this.indexReader.hasDeletions()) {
                    this.bits = MultiFields.getLiveDocs((IndexReader)LuceneReader.this.indexReader);
                    while (this.max > 0 && !this.bits.get(this.max)) {
                        --this.max;
                    }
                }
            }

            private Document nextDoc() throws CorruptIndexException, IOException {
                ++this.pos;
                if (this.pos > this.max) {
                    return null;
                }
                if (this.bits != null && !this.bits.get(this.pos)) {
                    return this.nextDoc();
                }
                return LuceneReader.this.indexReader.document(this.pos);
            }

            @Override
            public PrepareTMXEntry next() {
                try {
                    return LuceneReader.this.toEntry(this.nextDoc());
                }
                catch (Exception cie) {
                    throw new RuntimeException(cie);
                }
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.max;
            }
        };
    }

    @Override
    public Iterable<PrepareTMXEntry> search(SearchExpression expression) throws CorruptIndexException, IOException {
        if (!expression.searchSource) {
            return this.getEntries();
        }
        if (expression.searchTarget) {
            return this.getEntries();
        }
        if (expression.searchNotes) {
            return this.getEntries();
        }
        if (expression.text.length() < 4) {
            return this.getEntries();
        }
        if (expression.searchExpressionType == SearchExpression.SearchExpressionType.EXACT) {
            BooleanQuery query = this.buildQuery(expression.text, BooleanClause.Occur.MUST);
            return this.executeQuery(query, expression.numberOfResults);
        }
        if (expression.searchExpressionType == SearchExpression.SearchExpressionType.KEYWORD) {
            BooleanQuery query = new BooleanQuery();
            for (String word : expression.text.split(" ")) {
                query.add((Query)this.buildQuery(word, BooleanClause.Occur.MUST), BooleanClause.Occur.SHOULD);
            }
            return this.executeQuery(query, expression.numberOfResults);
        }
        if (expression.searchExpressionType == SearchExpression.SearchExpressionType.REGEXP) {
            BooleanQuery query = new BooleanQuery();
            Matcher m = LITTERAL.matcher(expression.text);
            while (m.find()) {
                query.add((Query)this.buildQuery(m.group(), BooleanClause.Occur.MUST), BooleanClause.Occur.MUST);
            }
            if (query.iterator().hasNext()) {
                return this.executeQuery(query, expression.numberOfResults);
            }
        }
        return this.getEntries();
    }

    private PrepareTMXEntry toEntry(Document doc) {
        PrepareTMXEntry entry = new PrepareTMXEntry();
        entry.source = doc.get("src");
        entry.translation = doc.get("tra");
        entry.creator = doc.get("author");
        entry.changer = doc.get("changer");
        try {
            entry.creationDate = Long.parseLong(doc.get("creationDate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            entry.changeDate = Long.parseLong(doc.get("changeDate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry;
    }
}

