/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.omegat.core.data.EntryKey;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;

public class RAMServer
extends UnicastRemoteObject
implements IDistantExternalMemory {
    public static final long serialVersionUID = 1L;
    Map<String, ProjectMemory.ContextTMXEntry> defaults = new HashMap<String, ProjectMemory.ContextTMXEntry>();
    Map<EntryKey, ProjectMemory.ContextTMXEntry> alternatives = new HashMap<EntryKey, ProjectMemory.ContextTMXEntry>();
    TreeMap<Long, EntryKey> events = new TreeMap();

    @Override
    public int getProjectSignature() {
        return 0;
    }

    @Override
    public List<ProjectMemory.ContextTMXEntry> findChanges(boolean withProperties, long timeStamp) throws RemoteException {
        NavigableMap<Long, EntryKey> lateEvents = this.events.tailMap(timeStamp, true);
        ArrayList<ProjectMemory.ContextTMXEntry> res = new ArrayList<ProjectMemory.ContextTMXEntry>(lateEvents.values().size());
        for (EntryKey eKey : lateEvents.values()) {
            if (eKey.file.equals("")) {
                res.add(this.defaults.get(eKey.sourceText));
                continue;
            }
            res.add(this.alternatives.get(eKey));
            if (!withProperties) continue;
            ProjectMemory.ContextTMXEntry entry = this.alternatives.get(eKey);
            entry.otherProperties = new ArrayList();
            entry.otherProperties.add(new TMXProp("file", eKey.file));
            entry.otherProperties.add(new TMXProp("id", eKey.id));
            entry.otherProperties.add(new TMXProp("prev", eKey.prev));
            entry.otherProperties.add(new TMXProp("next", eKey.next));
            entry.otherProperties.add(new TMXProp("path", eKey.path));
        }
        return res;
    }

    @Override
    public void registerTranslation(ProjectMemory.ContextTMXEntry entry) throws RemoteException {
        if (entry.isDefault) {
            this.defaults.put(entry.source, entry);
            this.addEvent(new EntryKey("", entry.source, "", "", "", ""));
        } else {
            EntryKey eKey = new EntryKey("unknown", entry.source, "unknown" + entry.hashCode(), "unknown", "unknown", "unknown");
            if (entry.otherProperties != null) {
                eKey = new EntryKey(StringUtil.nvl(entry.getPropValue("file"), "unknown"), entry.source, StringUtil.nvl(entry.getPropValue("id"), "unknown" + entry.hashCode()), StringUtil.nvl(entry.getPropValue("prev"), "unknown"), StringUtil.nvl(entry.getPropValue("file"), "unknown"), StringUtil.nvl(entry.getPropValue("path"), "unknown"));
            }
            this.alternatives.put(eKey, entry);
            this.addEvent(eKey);
        }
    }

    @Override
    public void removeTranslation(ProjectMemory.ContextTMXEntry entry) throws RemoteException {
        if (entry.isDefault) {
            this.defaults.remove(entry.source);
            this.addEvent(new EntryKey("", entry.source, "", "", "", ""));
        } else {
            EntryKey eKey = new EntryKey("unknown", entry.source, "unknown" + entry.hashCode(), "unknown", "unknown", "unknown");
            if (entry.otherProperties != null) {
                eKey = new EntryKey(StringUtil.nvl(entry.getPropValue("file"), "unknown"), entry.source, StringUtil.nvl(entry.getPropValue("id"), "unknown" + entry.hashCode()), StringUtil.nvl(entry.getPropValue("prev"), "unknown"), StringUtil.nvl(entry.getPropValue("file"), "unknown"), StringUtil.nvl(entry.getPropValue("path"), "unknown"));
            }
            this.alternatives.remove(eKey);
            this.addEvent(eKey);
        }
    }

    private void addEvent(EntryKey eKey) {
        long date = this.timeStamp();
        while (this.events.get(date) != null) {
            ++date;
        }
        this.events.put(date, eKey);
    }

    @Override
    public long timeStamp() {
        return System.currentTimeMillis();
    }
}

