/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.openxml;

import org.omegat.filters3.Attribute;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.xml.DefaultXMLDialect;
import org.omegat.filters3.xml.openxml.OpenXMLOptions;

public class OpenXMLDialect
extends DefaultXMLDialect {
    public void defineDialect(OpenXMLOptions options) {
        this.defineParagraphTags(new String[]{"w:p", "w:tab", "dc:title", "dc:subject", "dc:creator", "si", "comment", "definedName", "a:p", "c:v", "Text"});
        if (options.getBreakOnBr()) {
            this.defineParagraphTag("w:br");
        }
        if (options.getTranslateHiddenText()) {
            this.defineOutOfTurnTag("w:instrText");
        } else {
            this.defineIntactTag("w:instrText");
        }
        if (!options.getTranslateFallbackText()) {
            this.defineIntactTag("mc:Fallback");
        }
        this.defineIntactTags(new String[]{"authors", "rPh", "definedNames", "p:attrName", "a:tableStyleId", "c:f", "c:formatCode", "wp:align", "wp:posOffset", "wp14:pctWidth", "wp14:pctHeight", "w:fldChar", "cp:lastModifiedBy", "cp:revision", "cp:lastPrinted", "dcterms:created", "dcterms:modified", "cp:version", "xdr:col", "xdr:row", "xdr:colOff", "xdr:rowOff", "DocumentProperties", "DocumentSettings", "Colors", "FaceNames", "StyleSheets", "DocumentSheet", "Masters", "Misc", "TextBlock", "Geom", "Para", "Char", "Connection", "XForm", "Line", "Fill", "Event", "PageSheet", "PageProps", "PageLayout", "PrintProps", "PageHeight", "PageWidth", "Image", "PinY", "Width", "Height", "XForm1D", "EndX", "LayerMem", "TextXForm", "Control", "ForeignData", "Foreign", "Menu", "Act", "User", "Help", "Copyright", "VBProjectData", "FooterMargin", "HeaderMargin", "HeaderFooter", "Window", "Windows", "EventList", "Scratch", "TextBlock", "Protection", "Layout", "Icon", "vx:Event", "v14:Geom", "vx:Fill", "PreviewPicture", "vx:Char", "vx:Color", "vx:Line", "FillForegnd", "XForm1D", "ShdwBkgnd", "TextBkgnd", "vx:TextBkgnd"});
        this.defineTranslatableTagAttribute("sheet", "name");
        if (options.getTranslateWordArt()) {
            this.defineTranslatableTagAttribute("v:textpath", "string");
        }
        if (options.getTranslateLinks()) {
            this.defineTranslatableTagAttribute("Relationship", "Target");
        }
        boolean aggregationEnabled = options.getAggregateTags();
        this.setTagsAggregationEnabled(aggregationEnabled);
        this.setForceSpacePreserving(options.getSpacePreserving());
    }

    @Override
    public Boolean validateTranslatableTagAttribute(String tag, String attribute, Attributes atts) {
        if ("Relationship".equalsIgnoreCase(tag) && attribute.equalsIgnoreCase("Target")) {
            for (int i = 0; i < atts.size(); ++i) {
                Attribute otherAttribute = atts.get(i);
                if (!"TargetMode".equalsIgnoreCase(otherAttribute.getName()) || !"External".equalsIgnoreCase(otherAttribute.getValue())) continue;
                return super.validateTranslatableTagAttribute(tag, attribute, atts);
            }
            return false;
        }
        return super.validateTranslatableTagAttribute(tag, attribute, atts);
    }
}

