/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.Font;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.omegat.core.CoreEvents;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.FontSelectionPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class FontSelectionController
extends BasePreferencesController {
    private FontSelectionPanel panel;
    private Font oldFont;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_FONT");
    }

    private void initGui() {
        this.panel = new FontSelectionPanel();
        this.panel.fontComboBox.setModel(new DefaultComboBoxModel<String>(StaticUtils.getFontNames()));
        this.panel.fontComboBox.addActionListener(e -> this.panel.previewTextArea.setFont(this.getSelectedFont()));
        this.panel.sizeSpinner.addChangeListener(e -> this.panel.previewTextArea.setFont(this.getSelectedFont()));
    }

    @Override
    protected void initFromPrefs() {
        String fontName = Preferences.getPreferenceDefault("source_font", "Dialog");
        int fontSize = Preferences.getPreferenceDefault("source_font_size", 12);
        this.oldFont = new Font(fontName, 0, fontSize);
        this.panel.previewTextArea.setFont(this.oldFont);
        this.panel.fontComboBox.setSelectedItem(this.oldFont.getName());
        this.panel.sizeSpinner.setValue(this.oldFont.getSize());
        this.panel.applyToProjectFilesCheckBox.setSelected(Preferences.isPreference("project_files_use_font"));
    }

    @Override
    public void restoreDefaults() {
        this.oldFont = new Font("Dialog", 0, 12);
        this.panel.previewTextArea.setFont(this.oldFont);
        this.panel.fontComboBox.setSelectedItem(this.oldFont.getName());
        this.panel.sizeSpinner.setValue(this.oldFont.getSize());
        this.panel.applyToProjectFilesCheckBox.setSelected(false);
    }

    private Font getSelectedFont() {
        return new Font((String)this.panel.fontComboBox.getSelectedItem(), 0, ((Number)this.panel.sizeSpinner.getValue()).intValue());
    }

    @Override
    public void persist() {
        boolean applyToProjFiles = this.panel.applyToProjectFilesCheckBox.isSelected();
        Font newFont = this.getSelectedFont();
        if (!newFont.equals(this.oldFont) || applyToProjFiles != Preferences.isPreference("project_files_use_font")) {
            Preferences.setPreference("project_files_use_font", applyToProjFiles);
            Preferences.setPreference("source_font", newFont.getName());
            Preferences.setPreference("source_font_size", newFont.getSize());
            CoreEvents.fireFontChanged(newFont);
        }
    }
}

