/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.properties;

import java.awt.Color;
import org.omegat.util.gui.Styles;

public class FlashColorInterpolator {
    private static final double DEFAULT_DURATION = 300.0;
    private final double flashDuration;
    private final long startTime;
    private volatile long mark;
    private final Color colorMin;
    private final Color colorMax;

    public FlashColorInterpolator() {
        this(300.0, Styles.EditorColor.COLOR_NOTIFICATION_MIN.getColor(), Styles.EditorColor.COLOR_NOTIFICATION_MAX.getColor());
    }

    public FlashColorInterpolator(double duration, Color colorMin, Color colorMax) {
        this.flashDuration = duration;
        this.startTime = System.currentTimeMillis();
        this.colorMin = colorMin;
        this.colorMax = colorMax;
    }

    public void mark() {
        this.mark = System.currentTimeMillis();
    }

    public boolean isFlashing() {
        return (double)(this.mark - this.startTime) <= this.flashDuration;
    }

    private double getIntensity(long elapsed) {
        double x = (double)elapsed / this.flashDuration;
        return -4.0 * x * x + 4.0 * x;
    }

    public Color getColor() {
        long elapsed = this.mark - this.startTime;
        if ((double)elapsed >= this.flashDuration) {
            return this.colorMin;
        }
        double intensity = this.getIntensity(elapsed);
        double r = (double)this.colorMin.getRed() + (double)(this.colorMax.getRed() - this.colorMin.getRed()) * intensity;
        double g = (double)this.colorMin.getGreen() + (double)(this.colorMax.getGreen() - this.colorMin.getGreen()) * intensity;
        double b = (double)this.colorMin.getBlue() + (double)(this.colorMax.getBlue() - this.colorMin.getBlue()) * intensity;
        return new Color((int)r, (int)g, (int)b);
    }
}

