/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.ViewFactory;

public class CharacterWrapEditorKit
extends StyledEditorKit {
    private static final ViewFactory FACTORY = elem -> {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new CharacterWrapLabelView(elem);
            }
            if (kind.equals("paragraph")) {
                return new ParagraphView(elem);
            }
            if (kind.equals("section")) {
                return new BoxView(elem, 1);
            }
            if (kind.equals("component")) {
                return new ComponentView(elem);
            }
            if (kind.equals("icon")) {
                return new IconView(elem);
            }
        }
        return new CharacterWrapLabelView(elem);
    };

    @Override
    public ViewFactory getViewFactory() {
        return FACTORY;
    }

    private static class CharacterWrapLabelView
    extends LabelView {
        CharacterWrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }
}

