/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.util.TMXProp;

public class EntryKeyStore {
    private boolean store_linked = true;
    private boolean store_num = true;
    private boolean store_key = false;
    private boolean store_whenDefault = false;
    private WeakHashMap<EntryKey, Integer> cache = new WeakHashMap();

    public EntryKeyStore(Properties propList) {
        if ("false".equals(propList.getProperty("entryKey.store.linked"))) {
            this.store_linked = false;
        }
        if ("false".equals(propList.getProperty("entryKey.store.entryNum"))) {
            this.store_num = false;
        }
        if ("true".equals(propList.getProperty("entryKey.store.entryKey"))) {
            this.store_key = true;
        }
        if ("true".equals(propList.getProperty("entryKey.store.whenDefault"))) {
            this.store_whenDefault = true;
        }
        CoreEvents.registerProjectChangeListener((IProjectEventListener)new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                switch (eventType) {
                    case CLOSE: 
                    case CREATE: 
                    case LOAD: {
                        EntryKeyStore.this.cache.clear();
                    }
                }
            }
        });
    }

    public String toString() {
        return (this.store_linked ? "link;" : "no-link;") + (this.store_num ? "entry-number" : "no-entry-number;") + (this.store_key ? "entry-key" : "no-entry-key") + (this.store_whenDefault ? " (non-default only)" : "(including default)");
    }

    public List<TMXProp> buildProperties(ProjectMemory.ContextTMXEntry entry) {
        ArrayList<TMXProp> props = new ArrayList<TMXProp>();
        if (this.store_linked && entry.linked != null) {
            props.add(new TMXProp("externalLinked", entry.linked.toString()));
        }
        if (this.store_num) {
            props.add(new TMXProp("entryNum", Integer.toString(entry.entryNum)));
        }
        if (this.store_key) {
            EntryKey key = ((SourceTextEntry)Core.getProject().getAllEntries().get(entry.entryNum - 1)).getKey();
            props.add(new TMXProp("id", key.id));
            props.add(new TMXProp("prev", key.prev));
            props.add(new TMXProp("next", key.next));
            props.add(new TMXProp("path", key.path));
            props.add(new TMXProp("file", key.file));
        }
        return props;
    }

    public boolean shouldWrite(ProjectMemory.ContextTMXEntry entry) {
        return !(this.store_whenDefault ^ entry.isDefault);
    }

    public void fillEntry(ProjectMemory.ContextTMXEntry entry) {
        try {
            entry.linked = TMXEntry.ExternalLinked.valueOf((String)entry.getPropValue("externalLinked"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (TMXProp prop : entry.otherProperties) {
            properties.put(prop.getType(), prop.getValue());
        }
        EntryKey eKey = new EntryKey((String)properties.get("file"), entry.source, (String)properties.get("id"), (String)properties.get("prev"), (String)properties.get("next"), (String)properties.get("path"));
        entry.entryNum = -1;
        List projectEntries = Core.getProject().getAllEntries();
        if (eKey.hashCode() != entry.source.hashCode()) {
            if (this.cache.get(eKey) != null) {
                if (((SourceTextEntry)projectEntries.get(this.cache.get(eKey) - 1)).getKey().equals(eKey)) {
                    entry.entryNum = this.cache.get(eKey);
                    return;
                }
                this.cache.remove(eKey);
            }
            for (SourceTextEntry sourceEntry : projectEntries) {
                if (!sourceEntry.getKey().equals(eKey)) continue;
                entry.entryNum = sourceEntry.entryNum();
                this.cache.put(eKey, entry.entryNum);
                return;
            }
        }
        if (entry.entryNum < 0) {
            try {
                entry.entryNum = Integer.parseInt(entry.getPropValue("entryNum"));
                if (!((SourceTextEntry)projectEntries.get((int)(entry.entryNum - 1))).getKey().sourceText.equals(entry.source)) {
                    entry.entryNum = -1;
                }
                this.cache.put(eKey, entry.entryNum);
            }
            catch (Exception e) {
                entry.entryNum = -1;
            }
        }
    }
}

