=head1 MODE by_code

Tables contain a 64-bit integer as discriminant. 
You can see it as an intermediate between C<by_id::withRules> (which takes less space but has poor support for inheritance of personal tables)
and C<by_path> (which supports inheritance of personal tables but takes lot of space in the disk)

Note: by_code is an abstract mode, you have to write a subclass depending on the tree you want to create.
The two following modes are samples of by_code subclasses.

=cut
package by_code::TableCreator;

use parent TableCreator;

# by_code mode supports single inheritance
sub can_inherit { scalar(@_) == 2 }	

sub loadTables {
 	my ($self, $dir, $dbh) = @_;
	$self->SUPER::loadTables ($dir ? "$dir/by_code" : substr($INC{'by_code/TableCreator.pm'}, 0, rindex($INC{'by_code/TableCreator.pm'},'/')), $dbh || $self->{dbh});
	$self->SUPER::loadTables ($dir || substr($INC{'TableCreator.pm'}, 0, rindex($INC{'TableCreator.pm'},'/')), $dbh || $self->{dbh});
}

# sub $self->memCode($parent, $table, $src_lang, $tra_lang)		==> to be defined in a sub-class!!!

sub create_meta_info {
   my $self = shift; my $dbh = $self->{dbh};
   my $table = lc(shift); my $parent = lc(shift) || 'mem';
   my $src_lang = undef, $tra_lang = undef;
   foreach (@_) {
		print "ARG $_\n";
		$src_lang = lc($1) if /src\P{Letter}?(?:La?n?g?)?=(.+)/i; $tra_lang = lc($1) if /tra\P{Letter}?(?:La?n?g?)?=(.+)/i;	# supports syntax: srcLang, src_lang, src, srcLng, ...
   }
   my $mem_code = $self->memCode($parent, $table, $src_lang, $tra_lang);	# Warning: to be defined in subclass!!!
  $self->{dbh}->do("insert into PUBLIC.META_INFO (MEM_CODE, SRC_LANG, TRA_LANG) values ('$mem_code', '$srcLang', '$traLang')");
  if ($self->{dbh}->state eq '42P01') {
    $self->recursive_create_table ('public.meta_info'); $self->{dbh}->do($TableCreator::reqStr{VIEW}{'public.meta_view'});
    $self->{dbh}->do("insert into PUBLIC.META_INFO (MEM_CODE, SRC_LANG, TRA_LANG) values ('$mem_code', '$srcLang', '$traLang')") or die $DBI::errstr;
  }
   return (mem_code => $mem_code, stdParent => 'MEMX');
}

sub update_meta_info {} # Nothing to update
sub cancel_all {
  my ($self, %meta) = @_;
  $self->{dbh}->do ("delete from public.meta_info where mem_code = $meta{mem_code}");
}

sub checkId_sql { 
	my (undef,undef,%args) = @_; "mem_code bigint not null default $args{mem_code} check(mem_code=$args{mem_code})"
}
 
sub createIdRules {
	my ($self, $table, %args) = @_;
	print STDERR "createIdRules $table $args{mem_code} $args{stdParent}\n";
	if ($args{mem_path} && $args{stdParent} && ($args{stdParent} ne $table)) {
		my $table1 = $table; $table1 =~ s/\./_/;
		$self->{dbh}->do("create rule r_$table1 as 
					          on insert to $args{stdParent} where mem_code=$args{mem_code}
					          do instead insert into $table values (new.*)")
			or die $DBI::errstr;
	}
}
 
1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
