=head1 MODE by_id::noRules

Tables contain an integer as discriminant. All lines contain this value, so it takes more space on disk.

This mode is ideal if you make direct connections but with use of inheritance : when you do a query on a parent table, 
data coming from child tables are identified by their ID and joining with meta_info you can retreive all info such as child table name.

=cut
package by_id::noRules::TableCreator;

use parent TableCreator;

sub loadTables {
 	my ($self, $dir, $dbh) = @_;
	$self->SUPER::loadTables ($dir ? "$dir/by_id/noRules" : substr($INC{'by_id/noRules/TableCreator.pm'}, 0, rindex($INC{'by_id/noRules/TableCreator.pm'},'/')), $dbh || $self->{dbh});
	$self->SUPER::loadTables ($dir || substr($INC{'TableCreator.pm'}, 0, rindex($INC{'TableCreator.pm'},'/')), $dbh || $self->{dbh});
}

sub can_inherit { 1 }	# by_void mode supports multiple inheritance, so always true.

sub create_meta_info {
   my $self = shift; my $dbh = $self->{dbh};
   my $table = shift; my $parent = shift || 'MEM';
   my $src_lang = undef, $tra_lang = undef;
   foreach (@_) {
		print "ARG $_\n";
		$src_lang = $1 if /src\P{Letter}?(?:La?n?g?)?=(.+)/i; $tra_lang = $1 if /tra\P{Letter}?(?:La?n?g?)?=(.+)/i;	# supports syntax: srcLang, src_lang, src, srcLng, ...
   }
   # meta_info is required because it is used by jointures
   my $meta = $dbh->prepare ('insert into meta_info (table_schema, table_name, src_lang, tra_lang) values (?,?,?,?)');
   my ($schema, $table1) = split(/\./,$table); unless ($table1) { ($schema,$table1) = ('public',$table); }
	unless ($meta->execute (lc($schema), lc($table1), lc($src_lang) || '', lc($tra_lang) || '')) {
		$self->recursive_create_table ('public.meta_info');
		$meta->execute (lc($schema), lc($table1), lc($src_lang) || '', lc($tra_lang) || '');
	}
   my $mem_id = $dbh->last_insert_id(undef, 'public', 'meta_info', 'mem_id');
   return (mem_id => $mem_id);
}

sub update_meta_info {} # Nothing to update
sub cancel_all {
  my ($self, %meta) = @_;
  $self->{dbh}->do ("delete from public.meta_info where mem_id = $meta{mem_id}");
}

sub checkId_sql { my (undef,undef,%args) = @_; "mem_id integer not null default $args{mem_id}" }	# in noRules mode, mem_id exists but is not checked because it may be wrong with inheritance
 
sub createIdRules {}	# do not define rules
 
1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
