=head1 MODE by_path::withLangs

Tables contain a string as discriminant. All lines contain this value, so it takes more space on disk. 

Compared to "by_path::noLangs", it adds also languages in the path. Useful only if you use inheritance by language
(for example table for en-fr inherits from en-all)

=cut
package by_path::withLangs::TableCreator;

use parent by_path::TableCreator;

sub pathSeparator { '/' }

sub loadTables {
 	my ($self, $dir, $dbh) = @_;
	$self->SUPER::loadTables ($dir ? "$dir/by_path/withLangs" : substr($INC{'by_path/withLangs/TableCreator.pm'}, 0, rindex($INC{'by_path/withLangs/TableCreator.pm'},'/')), $dbh || $self->{dbh});
	$self->SUPER::loadTables ($dir || substr($INC{'TableCreator.pm'}, 0, rindex($INC{'TableCreator.pm'},'/')), $dbh || $self->{dbh});
}

# path, given parameters
sub memPath {
	my ($self, $parent, $table, $srcLang, $traLang) = @_;
	my $mem_path = $self->SUPER::memPath ($parent, $table); return $mem_path unless $srcLang or $traLang;
	return $mem_path .= "($srcLang,$traLang)";
}

sub do_insert_meta_info {
  my ($self, $mem_path, $srcLang, $traLang) = @_;
  $self->{dbh}->do("insert into PUBLIC.META_INFO (MEM_PATH) values ('$mem_path')");
  if ($self->{dbh}->state eq '42P01') {
    $self->recursive_create_table ('public.meta_info'); $self->{dbh}->do($TableCreator::reqStr{VIEW}{'public.meta_view'});
    $self->{dbh}->do("insert into PUBLIC.META_INFO (MEM_PATH) values ('$mem_path')") or die $DBI::errstr;
  }
}

 
1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
