#! /usr/bin/ruby

if ARGV.count < 2
    puts "Syntax: #{__FILE__} [--check|--analyse|DB-Name(:user:password)?(:host:port)?] (s)ftp://user:pass@host(:port)?/path [collection]?"
    puts "Import contents of FTP or SFTP to a memory"
    puts "\t--check only count number of TMX files and exit"
    puts "\t--stats count number of segments and exit, do not import in memory"
    exit
end

db = ARGV.shift; url = ARGV.shift

if url =~ /^ftp:\/\/(?:(.+?)(?::(.+?))\@)?(.+?)(?::(\d+))?\/(.*)$/ then
    require 'net/ftp'
    opt = Hash.new
    opt[:port] = $4.to_i if $4 != nil and $4.length > 0
    opt[:username] = $1 if $1 != nil and $1.length > 0
    opt[:password] = $2 if $2 != nil and $2.length > 0
    dir = Net::FTP.new $3, opt
    dir.login
    dir.chdir $5
    
    class FtpWrapper
        def initialize(dir, url) 
            @dir = dir;  @ls = dir.list('*.tmx') ; @url = url
        end
        def list() @ls end 
        def open(fileName,&f)
            begin
                require 'open-uri'
                URI.open("#{@url}/#{fileName}",&f) 
            rescue            
                # for the moment: make local copy
                @dir.get(fileName, "/tmp/#{fileName}")
                File.open("/tmp/#{fileName}",'r', &f)
                File.delete "/tmp/#{fileName}"
            end
        end       
    end
            
    dir = FtpWrapper.new(dir,rul)
elsif url =~ /^sftp:\/\/(?:(.+?)(?::(.+?))\@)?(.+?)(?::(\d+))?\/(.*)$/ then
    require 'net/sftp'
    host = $3; host = "#{$3}:#{$4}" if $4 != nil and $4.length > 0
    dir = Net::SFTP.start host, $1, :password => $2    
    
    class SFtpWrapper
        def initialize(dir,path) 
            @dir = dir; @path = path; 
            @ls = @dir.dir.entries("/#{path}").select { |item| item.name =~ /\.tmx$/ }
        end
        def list() @ls.collect { |item| item.name } end   
        def open(fileName,&f) @dir.file.open("/#{@path}/#{fileName}",&f)  end               
    end
    
    dir = SFtpWrapper.new(dir,$5)
else
    puts "#{__FILE__} requires ftp protocol"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

if db =~ /^\#/ then # using memory alias definition from config
    require 'yaml'; config = YAML.load_file "#{File.dirname(__FILE__)}/../conf/elefas.yml"
    require 'musci'; Musci::add_aliases(config['memories']) 
elsif db =~ /--check/ then
    puts "#{dir.list.count} files to be loaded"
    exit
elsif db =~ /^--(an|stat)/ then
    require 'spongiae/tmx'
    docs = units = segs = 0
    dir.list.each do |fileName|     
        puts "Read #{fileName}"; docs += 1
        dir.open(fileName) do |fileHandle|
            begin
                reader = Spongiae::TMX::TmxReader.new(fileHandle)
                reader.read_unit do |tu|
                    units += 1; segs += tu.variants.count
                end
            rescue
                # Ignore this file but continue
            end
        end
    end 
    puts "#{docs} documents ; #{units} units ; #{segs} segments"
    exit
end

require 'elefas/write'
writer = Elefas::ElefasWriter.new(db)

collection = ARGV.shift 

require 'spongiae/tmx'

dir.list.each do |fileName|
    start = Time.now; puts "#{start} - Start import #{fileName}"
    doc_id = writer.start_doc(fileName,collection)
    dir.open(fileName) do |fileHandle|
        reader = Spongiae::TMX::TmxReader.new(fileHandle)
        reader.read_unit do |tu|
            writer.write(tu,doc_id)
            puts "#{Time.now.to_i - start.to_i} seconds - #{writer.count_tu} units, #{writer.count_tuv} segments imported" if writer.count_tu % 100 == 0
        end
        writer.end_doc  # commit, but only if there was no exceptions!

        puts "#{Time.now.to_i - start.to_i} seconds - #{writer.count_tu} units, #{writer.count_tuv} segments imported"
    end
end


