###
# Version of Musci for Java/JDBC

require 'java'
Dir.glob(File.dirname(__FILE__) + '/java-lib/*.jar').each { |jar| $CLASSPATH <<  jar }

import java.sql.Connection
import java.sql.DriverManager

JRuby.runtime.jruby_class_loader.loadClass("org.postgresql.Driver")

module Musci
   
   class Connection
       def initialize(dbname, user = nil, password = nil, host = nil, port = nil, options = nil, tty = nil) 
           if user == nil then
              if dbname =~ /^\#(.+)$/ then
                  dbname = Musci::alias($1)
                  if dbname.is_a? Hash then
                      h = dbname
                      dbname = h['db']
                      user = h['user']; password = h['pass']
                      port = h['port']; host = h['host']
                  end
              end
              if dbname =~ /:/ then # 1-parameter format
                  dbname, user, password, host, port, options, tty = dbname.split(':').map { |item| item == nil ? nil : item.length == 0 ? nil : item }
              end
           end
           jdbcString = "jdbc:postgresql:#{dbname}"
           if port != nil then
               host = 'localhost' unless host
               jdbcString = "jdbc:postgresql://#{host}:#{port}/#{dbname}" 
           elsif host != nil then
               jdbcString = "jdbc:postgresql://#{host}/#{dbname}" 
           end
           
           Musci::token_connection(dbname)  # may reject or wait if too many connections
           @conn = DriverManager::getConnection(jdbcString, user, password) 
           @statements = {}
           @dbName = dbname
       end
       
       attr_reader :dbName
       
       def exec(sql, params = nil, type = nil, fieldId = nil, &sub)
           res = action = nil
           if type == Object then
               action = lambda { |row| res = row[fieldId] }
           elsif type == Array then
               res = Array.new
               action = lambda { |row| res << row[fieldId] }
           elsif block_given? then
               action = sub
           else
               action = lambda {}  # do nothing
           end
           if params == nil then
               st = @conn.createStatement
               if (sql =~ /^select/i) or (sql =~ /returning/) then
                   Musci::browseResultSet(st.executeQuery(sql)) { |row| action.call row } 
               else
                   return st.executeUpdate(sql)
               end
           else
               st = PreparedStatement.new(sql,@conn)
               st.exec(params) { |row| action.call row }
           end
           return res
       end
       
       def prepare(name,sql) @statements[name] = PreparedStatement.new(sql,@conn) end
        
       def close() @conn.close(); Musci::free_connection(@dbName) end        
   end
   
   class PreparedStatement
       def initialize(sql,conn)
           @sql = sql
           @paramNames = []
           @sql.gsub!(/[\$\:](\w+)/) { @paramNames << $1; '?' }
           @st = conn.prepareStatement(@sql)
       end
       
      def exec(params = nil,&sub)
          params = [params] if not (params.is_a? Hash or params.is_a? Array)
          for i in 0 .. (params.length - 1)
              @st.setObject(i + 1, params[i] != nil ? params[i] : params[@paramNames[i]])
          end
          if (@sql =~ /^select/i) or (@sql =~ /returning/)
              Musci::browseResultSet(@st.executeQuery) { |row| yield row }
          else
              @st.executeUpdate
          end
       end
   end
   
private
    def self.browseResultSet(rs,&sub)
        meta = rs.getMetaData
        while rs.next
            row = {}
            for i in 1 .. meta.getColumnCount
                row[i] = row[meta.getColumnName(i)] = rs.getObject(i)
            end
            yield row
        end        
    end

    
end
