#! /usr/bin/ruby

if ARGV.count < 2
    puts "Syntax: #{__FILE__} DB-Name(:user:password)?(:host:port)? file.tmx [collection[:docname]?]?"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

require 'elefas/write'

if ARGV[0] =~ /^\#/ then # using memory alias definition from config
    require 'yaml'; config = YAML.load_file "#{File.dirname(__FILE__)}/../conf/elefas.yml"
    require 'musci'; Musci::add_aliases(config['memories']) 
    Musci::def_token_policy(config['tokens-policy']) unless config['tokens-policy'] == nil
end

writer = Elefas::ElefasWriter.new(ARGV.shift)
    
file = ARGV.shift
unless file =~ /\.tmx$/i
    puts "File must be in TMX format"
    exit
end

collection = ARGV.shift ; docName = file.sub(/^.+[\/\\]/,'').sub(/\..+$/,'')
if collection != nil then
    if collection =~ /:/ then 
        collection, docName = collection.split /:/ 
    else 
        docName = file.sub(/^.+[\/\\]/,'').sub(/\..+$/,'')    # and collection remains as is
    end
end
doc_id = writer.start_doc(docName,collection)
puts "Inserted file #{file} as #{doc_id}"

require 'spongiae/tmx'

start = Time.now; puts "#{start} - Start import #{file}"

reader = Spongiae::TMX::TmxReader.new(file)
reader.read_unit do |tu|
    writer.write(tu,doc_id)
    puts "#{Time.now.to_i - start.to_i} seconds - #{writer.count_tu} units, #{writer.count_tuv} segments imported" if writer.count_tu % 100 == 0
end
writer.end_doc  # commit, but only if there was no exceptions!

puts "#{Time.now.to_i - start.to_i} seconds - #{writer.count_tu} units, #{writer.count_tuv} segments imported"
