#! /usr/bin/ruby

if ARGV.count < 1
    puts "Syntax: #{__FILE__} DB-Name(:user:password)?(:host:port)?"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

if ARGV[0] =~ /^\#/ then # using memory alias definition from config
    require 'yaml'; config = YAML.load_file "#{File.dirname(__FILE__)}/../conf/elefas.yml"
    require 'musci'; Musci::add_aliases(config['memories']) 
    Musci::def_token_policy(config['tokens-policy']) unless config['tokens-policy'] == nil
end

require 'elefas/read'
stats = Elefas::ElefasStatistics.new(ARGV.shift)

puts "Document(s): #{stats.documentsCount}"
puts "Collection(s): #{stats.collectionsCount}"
puts "Units: #{stats.unitsCount}"
puts "Segments: #{stats.segCount}"
puts "Database size: #{stats.dbSize}"


if ARGV.count > 0 and ARGV.shift =~ /-l/ then
    langs = stats.languages
    puts "languages: #{langs.count} (#{langs.to_a.join(',')})"
else
    puts "languages: #{stats.languages(true)}"
end

stats.close
