
create extension fuzzystrmatch;
create or replace function score(a text, b text) returns double precision as
$$
   select
        case
        when $1 = $2 then 1.0                         -- not only for optimisation:  also prevents division by 0 if a = b = '' 
        when octet_length($1) < 255 and octet_length($2) < 255 then         -- normal case : use levenshtein
          1.0 - 1.0 * levenshtein($1,$2) / greatest(i1, i2)
        when substring($1,1,1) = substring($2,1,1) then  -- identical left : use levenshtein on right part
             (select 1.0 - (1.0 - score(substring($1,l.m + 1, i1 - l.m), substring($2, l.m + 1, i2 - l.m))) * (greatest(i1,i2) - l.m)  / greatest(i1, i2)
               from ( select max(i) as m from generate_series(1, least(i1, i2)) i where substring($1,1,i) = substring($2,1,i) ) l) 
        when substring($1,i1,1) = substring($2,i2,1) then        -- identical right: use levenshtein on left part
             (select 1.0 - (1.0 - score(substring($1,1,i1 - l.m), substring($2, 1,i2 - l.m))) * (greatest(i1,i2) - l.m)  / greatest(i1, i2)
               from ( select max(i) as m from generate_series(1, least(i1, i2)) i where substring($1,i1 - i + 1,i) = substring($2,i2 - i + 1,i) ) l) 
        else   -- cannot use levenshtein, so we use similarity
           similarity($1,$2)
        end
   from (select length($1) as i1, length($2) as i2) x
$$ language sql;

