require 'musci'

module Elefas
    
    class ElefasClient
        # Can initialize by a connection or by parameters
        def initialize(dest)
            if dest.is_a? Musci::Connection then 
                @conn = dest
            else
                @conn = Musci::Connection.new(dest)
            end
        end
        
        def close() @conn.close() end        
            
        def self.VERSION
           return @@VERSION if defined? @@VERSION
           File.open("#{File.dirname(__FILE__)}/elefas/HISTORY",'r') do |f|
                @@VERSION = $1 if f.gets =~ /^(\d+\.\d+\.\d+)/
           end
           return @@VERSION
        end
    end
    
end
