###
# Version of Musci for Java/JDBC

require 'java'
Dir.glob('./java-lib/*.jar').each { |jar| $CLASSPATH <<  jar }

import java.sql.Connection
import java.sql.DriverManager

JRuby.runtime.jruby_class_loader.findClass("org.postgresql.Driver")

module Musci
   
   class Connection
       def initialize(dbname, user = nil, password = nil, host = nil, port = nil, options = nil, tty = nil) 
           jdbcString = "jdbc:postgresql:#{dbname}"
           if port != nil then
               host = 'localhost' unless host
               jdbcString = "jdbc:postgresql://#{host}:#{port}/#{dbname}" 
           else if host != nil then
               jdbcString = "jdbc:postgresql://#{host}/#{dbname}" 
           end
           
           @conn = DriverManager::getConnection(jdbcString, user, password) 
       end
       
       def exec(sql, params = nil, &sub)
          if params == nil
              @conn.exec(sql,sub)
          else
              @conn.exec_params(sql,params,&sub)
          end
       end
       
       def prepare(name,sql) Statement.new(name,sql,@conn) end
   end
   
   class Statement
       def initialize(sql)
           @sql = sql
           @paramNames = []
           @sql.gsub!(/[\$\:](\w+)/) { @paramNames << $1; "$#{@paramNames.count}" }
       end
   end
   
   class PreparedStatement < Statement
       def initialize(name,sql,conn)
           super(sql)
           @name = name
           @conn = conn
           @conn.prepare(@name,@sql)
       end
       
      def exec(params = nil, &sub)
          @conn.exec_prepared(@name,@paramNames.collect { |name| params[name] },sub)
       end       
   end
    
end
